/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.ext;

import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.Extension;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.ExportDialog;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.UmsatzTree;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ExportAddSumRowExtension
implements Extension {
    public static final String KEY_SUMROW_ADD = "sumrow.add";
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void extend(Extendable extendable) {
        if (!(extendable instanceof ExportDialog)) {
            return;
        }
        ExportDialog e = (ExportDialog)extendable;
        Class type = e.getType();
        if (!type.isAssignableFrom(Umsatz.class) && !type.isAssignableFrom(UmsatzTree.class)) {
            return;
        }
        boolean initial = ExportDialog.SETTINGS.getBoolean(KEY_SUMROW_ADD, false);
        Exporter.SESSION.put((Object)KEY_SUMROW_ADD, (Object)initial);
        final CheckboxInput check = new CheckboxInput(initial);
        check.setName(i18n.tr("Summe-Zeile am Ende der Datei anf\u00fcgen"));
        check.addListener(new Listener(){

            public void handleEvent(Event event) {
                Boolean value = (Boolean)check.getValue();
                Exporter.SESSION.put((Object)ExportAddSumRowExtension.KEY_SUMROW_ADD, (Object)value);
                ExportDialog.SETTINGS.setAttribute(ExportAddSumRowExtension.KEY_SUMROW_ADD, value.booleanValue());
            }
        });
        Container c = e.getContainer();
        c.addInput((Input)check);
        try {
            final Input format = e.getExporterList();
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    ExportDialog.ExportFormat exp = (ExportDialog.ExportFormat)format.getValue();
                    if (exp == null) {
                        return;
                    }
                    Exporter exporter = exp.getExporter();
                    check.setEnabled(exporter.suppportsExtension(ExportAddSumRowExtension.KEY_SUMROW_ADD));
                }
            };
            format.getControl().addListener(13, l);
            l.handleEvent(null);
        }
        catch (Exception ex) {
            Logger.error((String)"unable to determine export format", (Throwable)ex);
        }
    }
}

