/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.filter;

import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.filter.Filter;
import de.willuhn.jameica.hbci.rmi.Address;
import java.rmi.RemoteException;

public interface AddressFilter
extends Filter<Address> {
    public static final AddressFilter ALL = new AddressFilter(){

        @Override
        public boolean accept(Address address) throws RemoteException {
            return true;
        }
    };
    public static final AddressFilter INLAND = new AddressFilter(){

        @Override
        public boolean accept(Address address) throws RemoteException {
            if (address == null) {
                return false;
            }
            String blz = address.getBlz();
            String kto = address.getKontonummer();
            return blz != null && kto != null && blz.length() == HBCIProperties.HBCI_BLZ_LENGTH && kto.length() <= HBCIProperties.HBCI_KTO_MAXLENGTH_HARD;
        }
    };
    public static final AddressFilter FOREIGN = new AddressFilter(){

        @Override
        public boolean accept(Address address) throws RemoteException {
            if (address == null) {
                return false;
            }
            String iban = address.getIban();
            return iban != null && iban.length() > 0 && iban.length() <= HBCIProperties.HBCI_IBAN_MAXLENGTH;
        }
    };

    @Override
    public boolean accept(Address var1) throws RemoteException;
}

