/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.filter;

import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.filter.Filter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public abstract class KontoFilter
implements Filter<Konto> {
    public static final KontoFilter ALL = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            return true;
        }
    };
    public static final KontoFilter ONLINE = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            if (!ACTIVE.accept(konto)) {
                return false;
            }
            return !konto.hasFlag(2);
        }
    };
    public static final KontoFilter OFFLINE = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            if (!ACTIVE.accept(konto)) {
                return false;
            }
            return konto.hasFlag(2);
        }
    };
    public static final KontoFilter ACTIVE = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            if (konto == null) {
                return false;
            }
            return !konto.hasFlag(1);
        }
    };
    public static final KontoFilter FOREIGN = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            if (!ONLINE.accept(konto)) {
                return false;
            }
            String iban = konto.getIban();
            return iban != null && iban.length() > 0 && iban.length() <= HBCIProperties.HBCI_IBAN_MAXLENGTH;
        }
    };
    public static final KontoFilter SYNCED = new KontoFilter(){

        @Override
        public boolean accept(Konto konto) throws RemoteException {
            if (konto == null || konto.hasFlag(1)) {
                return false;
            }
            if (!konto.hasFlag(2)) {
                return true;
            }
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeEngine engine = (SynchronizeEngine)service.get(SynchronizeEngine.class);
            return engine.supports(SynchronizeJobKontoauszug.class, konto);
        }
    };

    @Override
    public abstract boolean accept(Konto var1) throws RemoteException;

    public static final KontoFilter SEARCH(final String text, final Integer ignoreFlags, final Integer accountType) {
        return new KontoFilter(){

            @Override
            public boolean accept(Konto konto) throws RemoteException {
                if (konto == null) {
                    return false;
                }
                if (ignoreFlags != null) {
                    int f = ignoreFlags;
                    int[] nArray = new int[]{1, 2};
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int flag = nArray[n2];
                        if ((f & flag) == flag && konto.hasFlag(flag)) {
                            return false;
                        }
                        ++n2;
                    }
                }
                if (!(accountType == null || konto.getAccountType() != null && konto.getAccountType().equals(accountType))) {
                    return false;
                }
                String s = StringUtils.trimToNull((String)text);
                if (s == null) {
                    return true;
                }
                s = s.toLowerCase();
                String s1 = StringUtils.trimToEmpty((String)konto.getBezeichnung()).toLowerCase();
                String s2 = StringUtils.trimToEmpty((String)konto.getBic()).toLowerCase();
                String s3 = StringUtils.trimToEmpty((String)konto.getBLZ()).toLowerCase();
                String s4 = StringUtils.trimToEmpty((String)konto.getIban()).toLowerCase();
                String s5 = StringUtils.trimToEmpty((String)konto.getKategorie()).toLowerCase();
                String s6 = StringUtils.trimToEmpty((String)konto.getKommentar()).toLowerCase();
                String s7 = StringUtils.trimToEmpty((String)konto.getKontonummer()).toLowerCase();
                String s8 = StringUtils.trimToEmpty((String)konto.getKundennummer()).toLowerCase();
                String s9 = StringUtils.trimToEmpty((String)konto.getName()).toLowerCase();
                return s1.contains(s) || s2.contains(s) || s3.contains(s) || s4.contains(s) || s5.contains(s) || s6.contains(s) || s7.contains(s) || s8.contains(s) || s9.contains(s);
            }
        };
    }

    public static KontoFilter createForeign(final Class<? extends SynchronizeJob> type) {
        return new KontoFilter(){

            @Override
            public boolean accept(Konto konto) throws RemoteException {
                boolean b = FOREIGN.accept(konto);
                if (!b) {
                    return false;
                }
                if (type == null) {
                    return true;
                }
                try {
                    BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                    SynchronizeEngine engine = (SynchronizeEngine)bs.get(SynchronizeEngine.class);
                    SynchronizeBackend backend = engine.getBackend(type, konto);
                    return backend == null || backend.supports(type, konto);
                }
                catch (ApplicationException ae) {
                    return false;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to determine if account is supported, will rather accept it", (Throwable)e);
                    return true;
                }
            }
        };
    }
}

