/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractDateInput
extends DateInput {
    private static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final Map<String, Date> cache = new HashMap<String, Date>();
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String param = null;

    public AbstractDateInput(Date date) {
        this(date, null);
    }

    public AbstractDateInput(Date date, String parameter) {
        super(date, HBCI.DATEFORMAT);
        this.setName(i18n.tr("Datum"));
        this.param = parameter != null ? parameter : "date";
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                AbstractDateInput.this.store();
            }
        });
        if (date != null) {
            return;
        }
        if (cache.containsKey(this.param)) {
            this.setValue(cache.get(this.param));
            return;
        }
        try {
            String s = settings.getString(this.param, null);
            if (s != null && s.length() > 0) {
                this.setValue(HBCI.DATEFORMAT.parse(s));
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
        this.setValue(this.getDefault());
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.store();
    }

    private void store() {
        Date d = (Date)this.getValue();
        settings.setAttribute(this.param, d != null ? HBCI.DATEFORMAT.format(d) : null);
        cache.put(this.param, d);
    }

    abstract Date getDefault();
}

