/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SearchInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.dialogs.AdresseAuswahlDialog;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AddressInput
implements Input {
    private Map<String, Object> data = new HashMap<String, Object>();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private AddressFilter filter = null;
    private SuggestInput input = null;
    private Button button = null;
    private String validChars = HBCIProperties.HBCI_DTAUS_VALIDCHARS;

    public AddressInput(String name) {
        this(name, null);
    }

    public AddressInput(String name, final AddressFilter filter) {
        this.filter = filter;
        this.input = new SuggestInput(name);
        String s = "...";
        int os = Application.getPlatform().getOS();
        if (os == 2 || os == 5) {
            s = " ... ";
        }
        this.button = new Button(s, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    AdresseAuswahlDialog d = new AdresseAuswahlDialog(0, filter);
                    Address a = (Address)d.open();
                    if (a != null) {
                        AddressInput.this.input.setValue(a);
                    }
                }
                catch (OperationCanceledException oce) {
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"error while applying address", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der Adresse: {0}", e.getMessage()), 1));
                }
            }
        });
    }

    public void addListener(Listener l) {
        this.input.addListener(l);
    }

    public void disable() {
        this.input.disable();
        this.button.setEnabled(false);
    }

    public void enable() {
        this.input.enable();
        this.button.setEnabled(true);
    }

    public void focus() {
        this.input.focus();
    }

    public Control getControl() {
        return this.input.getControl();
    }

    public String getName() {
        return this.input.getName();
    }

    public Object getValue() {
        return this.input.getValue();
    }

    public boolean hasChanged() {
        return this.input.hasChanged();
    }

    public boolean isEnabled() {
        return this.input.isEnabled();
    }

    public boolean isMandatory() {
        return this.input.isMandatory();
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String text) {
        this.input.setText(text);
    }

    public void setValidChars(String chars) {
        this.validChars = chars;
    }

    public void paint(Composite parent, int width) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        GridData g = new GridData(768);
        comp.setLayoutData((Object)g);
        this.input.paint(comp);
        try {
            this.button.paint(comp);
        }
        catch (RemoteException re) {
            Logger.error((String)"error while rendering button", (Throwable)re);
        }
    }

    public void paint(Composite parent) {
        this.paint(parent, 0);
    }

    public void setComment(String comment) {
        this.input.setComment(comment);
    }

    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setMandatory(boolean mandatory) {
        this.input.setMandatory(mandatory);
    }

    public void setName(String name) {
        this.input.setName(name);
    }

    public void setValue(Object value) {
        this.input.setValue(value);
    }

    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    private class SuggestInput
    extends SearchInput {
        private SuggestInput(String name) {
            this.setValue(name);
            this.setValidChars(AddressInput.this.validChars);
            this.setMaxLength(HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
            this.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        Address a = (Address)event.data;
                        SuggestInput.this.setText(a.getName());
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to apply name", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen des Namens"), 1));
                    }
                }
            });
        }

        public void setText(String s) {
            String before = s;
            String after = HBCIProperties.clean(s, AddressInput.this.validChars);
            super.setText(after);
            if (before != null && !before.equals(after)) {
                GUI.getView().setErrorText(i18n.tr("Im Namen wurden nicht zul\u00e4ssige Zeichen entfernt"));
            }
        }

        protected String format(Object bean) {
            if (bean == null) {
                return null;
            }
            if (!(bean instanceof Address)) {
                return bean.toString();
            }
            try {
                String comment;
                Address a = (Address)bean;
                StringBuffer sb = new StringBuffer(a.getName());
                String blz = a.getBlz();
                if (blz != null && blz.length() > 0) {
                    sb.append(" - ");
                    String bankName = HBCIProperties.getNameForBank(blz);
                    if (bankName != null && bankName.length() > 0) {
                        sb.append(bankName);
                    } else {
                        sb.append("BLZ ");
                        sb.append(blz);
                    }
                }
                if ((comment = a.getKommentar()) != null && comment.length() > 0) {
                    sb.append(" (");
                    sb.append(comment);
                    sb.append(")");
                } else {
                    String iban = a.getIban();
                    if (iban != null && iban.length() > 0) {
                        sb.append(" - IBAN " + StringUtils.abbreviateMiddle((String)iban, (String)"...", (int)10));
                    }
                }
                return sb.toString();
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to format address", (Throwable)re);
                return null;
            }
        }

        public void setValue(Object o) {
            super.setValue(o);
        }

        public List startSearch(String text) {
            try {
                AddressbookService service = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
                List l = service.findAddresses(text);
                if (l == null || l.size() == 0) {
                    return l;
                }
                ArrayList<Address> result = new ArrayList<Address>();
                int i = 0;
                while (i < l.size()) {
                    Address a = (Address)l.get(i);
                    if (AddressInput.this.filter == null || AddressInput.this.filter.accept(a)) {
                        result.add(a);
                    }
                    ++i;
                }
                return result;
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            }
            catch (Exception e) {
                Logger.error((String)"error while searching in address book", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Suchen im Adressbuch: {0}", e.getMessage()), 1));
            }
            return new ArrayList();
        }
    }
}

