/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.input.AccountInput;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BICInput
extends AccountInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Listener listener = new BICListener();
    private static final String LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz";

    public BICInput(String value) {
        super(value, HBCIProperties.HBCI_BIC_MAXLENGTH + 4);
        this.setValidChars(String.valueOf(HBCIProperties.HBCI_BIC_VALIDCHARS) + LOWERCASE_CHARS);
        this.setName("BIC");
        this.setComment("");
        this.addListener(this.listener);
        this.listener.handleEvent(null);
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.listener.handleEvent(null);
    }

    private class BICListener
    implements Listener {
        private BICListener() {
        }

        public void handleEvent(Event arg0) {
            try {
                String b = (String)BICInput.this.getValue();
                if (b != null && b.length() > 0) {
                    if (b.indexOf(32) != -1) {
                        b = b.replaceAll(" ", "");
                    }
                    b = b.toUpperCase();
                    b = HBCIProperties.checkBIC(b);
                    BICInput.super.setValue((Object)b);
                    BICInput.this.setComment(HBCIProperties.getNameForBank(b));
                } else {
                    BICInput.this.setComment("");
                }
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 2));
            }
            catch (Exception e) {
                Logger.error((String)"error while checking BIC", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Pr\u00fcfen der BIC: {0}", e.getMessage()), 2));
            }
        }
    }
}

