/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.input.AccountInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BLZInput
extends AccountInput {
    private List<Listener> blzListener = new ArrayList<Listener>();
    private Listener listener = null;
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public BLZInput(String value) {
        super(value, HBCIProperties.HBCI_BLZ_LENGTH + 3);
        this.listener = new BLZListener();
        this.setValidChars(HBCIProperties.HBCI_BLZ_VALIDCHARS);
        this.setName(this.i18n.tr("BLZ"));
        this.setComment("");
        this.addListener(this.listener);
        this.listener.handleEvent(null);
    }

    public void addBLZListener(Listener l) {
        this.blzListener.add(l);
    }

    public Control getControl() {
        Control c = super.getControl();
        c.addListener(2, (Listener)new DelayedListener(this.listener));
        c.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                int len;
                String b = (String)BLZInput.this.getValue();
                if (b == null || b.length() == 0) {
                    return;
                }
                if (b.indexOf(32) != -1) {
                    b = b.replaceAll(" ", "");
                }
                if ((len = b.length()) >= HBCIProperties.HBCI_BLZ_LENGTH) {
                    event.doit = !Character.isDigit(event.character);
                }
            }
        });
        return c;
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.listener.handleEvent(null);
    }

    private class BLZListener
    implements Listener {
        private BLZListener() {
        }

        public void handleEvent(Event arg0) {
            try {
                String b = (String)BLZInput.this.getValue();
                if (b != null && b.length() > 0) {
                    if (b.indexOf(32) != -1) {
                        b = b.replaceAll(" ", "");
                    }
                    if (b.length() == HBCIProperties.HBCI_BLZ_LENGTH) {
                        String name = HBCIProperties.getNameForBank(b);
                        BLZInput.this.setComment(name);
                        if (StringUtils.trimToNull((String)name) != null) {
                            arg0.data = b;
                            for (Listener l : BLZInput.this.blzListener) {
                                l.handleEvent(arg0);
                            }
                        }
                        return;
                    }
                }
                BLZInput.this.setComment("");
            }
            catch (Exception e) {
                BLZInput.this.setComment("");
            }
        }
    }
}

