/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kapott.hbci.passport.HBCIPassport;

public class HBCIVersionInput
extends SelectInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final List<HBCIVersion> VERSIONS = Collections.unmodifiableList(new ArrayList<HBCIVersion>(){
        {
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_300, true));
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_PLUS, true));
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_220, false));
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_210, true));
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_201, true));
            this.add(new HBCIVersion(org.kapott.hbci.manager.HBCIVersion.HBCI_400, false));
        }
    });

    private static HBCIVersion findById(String id) {
        if (id == null) {
            return null;
        }
        for (HBCIVersion version : VERSIONS) {
            if (!id.equals(version.getId())) continue;
            return version;
        }
        return null;
    }

    public HBCIVersionInput() throws RemoteException {
        this(null, null);
    }

    public HBCIVersionInput(HBCIPassport passport, String selected) throws RemoteException {
        super(HBCIVersionInput.createList(passport, selected), (Object)HBCIVersionInput.findById(selected));
        this.setName(i18n.tr("HBCI-Version"));
        if (passport != null) {
            this.setPleaseChoose(i18n.tr("Version aus Sicherheitsmedium lesen"));
        }
    }

    private static List createList(HBCIPassport passport, String selected) {
        String[] s;
        ArrayList<String> list = null;
        if (passport != null && (list = new ArrayList<String>(Arrays.asList(s = passport.getSuppVersions()))).contains("220") && !list.contains("plus")) {
            list.add(list.indexOf("220") + 1, "plus");
        }
        ArrayList<HBCIVersion> versions = new ArrayList<HBCIVersion>();
        if (list == null || list.size() == 0) {
            versions.addAll(VERSIONS);
        } else {
            for (String s2 : list) {
                HBCIVersion version = HBCIVersionInput.findById(s2);
                if (version == null) {
                    Logger.warn((String)("unknown HBCI version: " + s2 + ", skipping"));
                    continue;
                }
                versions.add(version);
            }
        }
        ArrayList<HBCIVersion> result = new ArrayList<HBCIVersion>();
        for (HBCIVersion v : versions) {
            if (v.active) {
                result.add(v);
                continue;
            }
            if (selected == null || !selected.equals(v.getId())) continue;
            result.add(v);
        }
        return result;
    }

    public Object getValue() {
        HBCIVersion o = (HBCIVersion)super.getValue();
        return o != null ? o.getId() : null;
    }

    public void setPreselected(Object preselected) {
        super.setPreselected(preselected instanceof String ? HBCIVersionInput.findById((String)preselected) : null);
    }

    public void setValue(Object o) {
        super.setValue(o instanceof String ? HBCIVersionInput.findById((String)o) : null);
    }

    private static class HBCIVersion {
        private org.kapott.hbci.manager.HBCIVersion version = null;
        private boolean active = true;

        private HBCIVersion(org.kapott.hbci.manager.HBCIVersion version, boolean active) {
            this.version = version;
            this.active = active;
        }

        public String getId() {
            return this.version.getId();
        }

        public String toString() {
            return this.version.getName();
        }
    }
}

