/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class IBANInput
extends TextInput {
    private Input bicInput = null;

    public IBANInput(String value, Input bicInput) {
        super(HBCIProperties.formatIban(value), HBCIProperties.HBCI_IBAN_MAXLENGTH + 5);
        this.setValidChars(HBCIProperties.HBCI_IBAN_VALIDCHARS);
        this.setName("IBAN");
        this.bicInput = bicInput;
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                String s = (String)IBANInput.this.getValue();
                if (s == null || s.length() < 2) {
                    return;
                }
                IBANInput.this.setValue(HBCIProperties.formatIban(s));
            }
        });
    }

    public void setValue(Object value) {
        super.setValue(value != null ? HBCIProperties.formatIban(value.toString()) : null);
        if (value == null) {
            return;
        }
        String s = StringUtils.trimToNull((String)StringUtils.deleteWhitespace((String)value.toString()));
        if (s == null) {
            return;
        }
        try {
            IBAN iban = HBCIProperties.getIBAN(s);
            if (iban == null) {
                return;
            }
            if (this.bicInput == null) {
                return;
            }
            if (StringUtils.trimToNull((String)((String)this.bicInput.getValue())) != null) {
                return;
            }
            String bic = StringUtils.trimToNull((String)iban.getBIC());
            if (bic == null) {
                return;
            }
            this.bicInput.setValue((Object)bic);
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
    }

    public Object getValue() {
        String s = (String)super.getValue();
        if (s == null) {
            return s;
        }
        return StringUtils.deleteWhitespace((String)s);
    }

    public void setValidChars(String chars) {
        super.setValidChars(String.valueOf(chars) + " ");
    }
}

