/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class KontoInput
extends SelectInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(KontoInput.class);
    private Konto konto = null;
    private static List<String> groups = null;
    private KontoListener listener = null;
    private String token = null;
    private boolean store = true;
    private Control control = null;
    private boolean supportGroups = false;
    private MessageConsumer mc = new SaldoMessageConsumer();

    public KontoInput(Konto konto, KontoFilter filter) throws RemoteException {
        super(KontoInput.init(filter), (Object)konto);
        List konten;
        this.konto = konto;
        this.setName(i18n.tr("Konto"));
        if ((groups == null || groups.size() == 0) && (konten = this.getList()) != null && konten.size() == 1) {
            this.setPreselected(konten.get(0));
        }
        this.setPleaseChoose(i18n.tr("Bitte w\u00e4hlen..."));
        this.setComment("");
        this.listener = new KontoListener();
        this.addListener(this.listener);
        this.listener.handleEvent(null);
    }

    public void setSupportGroups(boolean b) {
        this.supportGroups = b;
    }

    public void setRememberSelection(String s, boolean store) {
        if (s == null || s.length() == 0) {
            return;
        }
        this.token = s;
        this.store = store;
        String id = settings.getString(this.token, null);
        if (this.konto == null && id != null && id.length() > 0) {
            try {
                for (Konto k : KontoUtil.getKonten(null)) {
                    if (!id.equals(k.getID())) continue;
                    this.setPreselected(k);
                    return;
                }
                if (this.supportGroups) {
                    for (String group : KontoUtil.getGroups()) {
                        if (!id.equals(group)) continue;
                        this.setPreselected(group);
                        return;
                    }
                } else {
                    settings.setAttribute(this.token, null);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to load accounts", (Throwable)e);
            }
        }
    }

    public void setRememberSelection(String s) {
        this.setRememberSelection(s, true);
    }

    public Control getControl() {
        if (this.control != null) {
            return this.control;
        }
        this.control = super.getControl();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(KontoInput.this.mc);
                KontoInput.this.storeSelection();
            }
        });
        return this.control;
    }

    private void storeSelection() {
        if (!this.store || this.token == null) {
            return;
        }
        try {
            Object o = this.getValue();
            String value = null;
            if (o != null) {
                value = o instanceof Konto ? ((Konto)o).getID() : o.toString();
            }
            settings.setAttribute(this.token, value);
        }
        catch (Exception e) {
            settings.setAttribute(this.token, null);
        }
    }

    private static List init(KontoFilter filter) throws RemoteException {
        groups = KontoUtil.getGroups();
        boolean haveGroups = groups.size() > 0;
        DBIterator it = Settings.getDBService().createList(Konto.class);
        it.setOrder("ORDER BY LOWER(kategorie), blz, bezeichnung, kontonummer");
        ArrayList<Object> l = new ArrayList<Object>();
        String current = null;
        while (it.hasNext()) {
            String kat;
            Konto k = (Konto)it.next();
            if (filter != null && !filter.accept(k)) continue;
            if (haveGroups && (kat = StringUtils.trimToNull((String)k.getKategorie())) != null && (current == null || !kat.equals(current))) {
                l.add(kat);
                current = kat;
            }
            l.add(k);
        }
        return l;
    }

    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof String && !this.supportGroups) {
            GUI.getView().setErrorText(i18n.tr("Die Auswahl einer Konto-Gruppen ist hier nicht m\u00f6glich"));
            return null;
        }
        return o;
    }

    protected String format(Object bean) {
        if (bean == null) {
            return null;
        }
        if (!(bean instanceof Konto)) {
            return bean.toString();
        }
        try {
            String blz;
            String bankName;
            Konto k = (Konto)bean;
            boolean disabled = k.hasFlag(1);
            StringBuffer sb = new StringBuffer();
            if (groups.size() > 0) {
                sb.append("   ");
            }
            if (disabled) {
                sb.append("[");
            }
            if ((bankName = HBCIProperties.getNameForBank(blz = k.getBLZ())) != null && bankName.length() > 0) {
                sb.append(bankName);
            } else {
                sb.append("BLZ ");
                sb.append(blz);
            }
            sb.append(": " + k.getName());
            String bez = k.getBezeichnung();
            if (bez != null && bez.length() > 0) {
                sb.append(" - ");
                sb.append(bez);
            }
            sb.append(" [" + i18n.tr("Kto. {0}", k.getKontonummer()) + "]");
            if (k.getSaldoDatum() != null) {
                sb.append(" - ");
                sb.append(i18n.tr("Saldo: {0} {1}", new String[]{HBCI.DECIMALFORMAT.format(k.getSaldo()), k.getWaehrung()}));
            }
            if (disabled) {
                sb.append("]");
            }
            return sb.toString();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to format address", (Throwable)re);
            return null;
        }
    }

    private class KontoListener
    implements Listener {
        private KontoListener() {
        }

        public void handleEvent(Event event) {
            try {
                Object o = KontoInput.this.getValue();
                if (o == null || !(o instanceof Konto)) {
                    KontoInput.this.setComment("");
                    return;
                }
                Konto konto = (Konto)o;
                String w = konto.getWaehrung();
                Date datum = konto.getSaldoDatum();
                if (datum != null) {
                    KontoInput.this.setComment(i18n.tr("Saldo: {0} {1} vom {2}", new String[]{HBCI.DECIMALFORMAT.format(konto.getSaldo()), w, HBCI.DATEFORMAT.format(datum)}));
                } else {
                    KontoInput.this.setComment("");
                }
            }
            catch (RemoteException er) {
                Logger.error((String)"error while updating currency", (Throwable)er);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler bei Ermittlung der W\u00e4hrung"));
            }
        }
    }

    private class SaldoMessageConsumer
    implements MessageConsumer {
        private SaldoMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{SaldoMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            SaldoMessage msg = (SaldoMessage)message;
            GenericObject o = msg.getObject();
            if (!(o instanceof Konto)) {
                return;
            }
            final Konto konto = (Konto)o;
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    List list = null;
                    try {
                        list = KontoInput.this.getList();
                        if (list == null) {
                            return;
                        }
                        int i = 0;
                        while (i < list.size()) {
                            Konto k;
                            Object item = list.get(i);
                            if (item instanceof Konto && BeanUtil.equals((Object)konto, (Object)(k = (Konto)item))) {
                                list.set(i, konto);
                                break;
                            }
                            ++i;
                        }
                        KontoInput.this.setValue(KontoInput.this.getValue());
                        KontoInput.this.setList(list);
                        if (((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoInput.this.listener != null) {
                            ((SaldoMessageConsumer)SaldoMessageConsumer.this).KontoInput.this.listener.handleEvent(null);
                        }
                    }
                    catch (NoSuchMethodError e) {
                        Logger.warn((String)(String.valueOf(e.getMessage()) + " - update your jameica installation"));
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to refresh konto", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

