/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.PassportRegistry;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PassportInput
extends SelectInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static List<Passport> passports = null;

    public PassportInput() throws RemoteException {
        this(null);
    }

    public PassportInput(Konto konto) throws RemoteException {
        super(PassportInput.init(), null);
        List<Passport> list = PassportInput.init();
        String currentClass = konto != null ? konto.getPassportClass() : null;
        for (Passport p : list) {
            if (currentClass == null || !p.getClass().getName().equals(currentClass)) continue;
            this.setPreselected(p);
            break;
        }
        this.setPleaseChoose("Bitte w\u00e4hlen...");
        this.setAttribute("name");
        this.setName(i18n.tr("Verfahren"));
    }

    public void update(SynchronizeBackend backend) {
        List<Passport> all = PassportInput.init();
        ArrayList<Passport> result = new ArrayList<Passport>();
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        boolean hb = backend != null && ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).equals(backend);
        for (Passport p : all) {
            boolean hp;
            boolean bl = hp = p instanceof de.willuhn.jameica.hbci.passports.ddv.rmi.Passport || p instanceof de.willuhn.jameica.hbci.passports.rdh.rmi.Passport || p instanceof de.willuhn.jameica.hbci.passports.pintan.rmi.Passport;
            if (hb != hp) continue;
            result.add(p);
        }
        this.setList(result);
        this.setEnabled(result.size() > 0);
    }

    private static List<Passport> init() {
        if (passports == null) {
            try {
                passports = Arrays.asList(PassportRegistry.getPassports());
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            }
            catch (Exception e) {
                Logger.error((String)"error while loading passport list", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Laden der HBCI-Verfahren"), 1));
            }
        }
        if (passports == null) {
            passports = new ArrayList<Passport>();
        }
        return passports;
    }
}

