/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RangeInput
extends SelectInput {
    private static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String param = null;
    private Input from = null;
    private Input to = null;
    private boolean inUpdate = false;

    public RangeInput(Input from, Input to) {
        this(from, to, Range.Category.ZAHLUNGSVERKEHR, null);
    }

    public RangeInput(Input from, Input to, Range.Category category, String parameter) {
        this(Range.getActiveRanges(category), from, to, parameter);
    }

    public RangeInput(List<Range> ranges, Input from, Input to, String parameter) {
        super(ranges, null);
        this.from = from;
        this.to = to;
        this.param = parameter != null ? parameter : "transferlist.filter.range";
        this.setPleaseChoose(i18n.tr("Bitte w\u00e4hlen..."));
        this.setName(i18n.tr("Zeitraum"));
        Range preset = Range.byId(settings.getString(this.param, null));
        if (preset != null) {
            this.setValue(preset);
            this.applyRange(preset);
        }
        if (from != null || to != null) {
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    if (RangeInput.this.inUpdate) {
                        return;
                    }
                    RangeInput.this.setValue(null);
                    settings.setAttribute(RangeInput.this.param, null);
                    RangeInput.this.checkRange();
                }
            };
            if (from != null) {
                from.addListener(l);
            }
            if (to != null) {
                to.addListener(l);
            }
        }
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                Range choosen = (Range)RangeInput.this.getValue();
                settings.setAttribute(RangeInput.this.param, choosen != null ? choosen.getId() : null);
                RangeInput.this.applyRange(choosen);
            }
        });
        this.hasChanged();
    }

    private void checkRange() {
        if (this.from == null || this.to == null) {
            return;
        }
        Object oFrom = this.from.getValue();
        Object oTo = this.to.getValue();
        if (!(oFrom instanceof Date) || !(oTo instanceof Date)) {
            return;
        }
        Date dTo = (Date)oTo;
        Date dFrom = (Date)oFrom;
        if (dTo.before(dFrom)) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte pr\u00fcfen Sie den Zeitraum. Das Bis-Datum sollte nicht vor dem Von-Datum liegen."), 2));
            return;
        }
        NotificationPanel panel = GUI.getView().getNotificationPanel();
        if (panel != null) {
            panel.reset();
        }
    }

    private void applyRange(Range range) {
        if (range == null) {
            return;
        }
        try {
            this.inUpdate = true;
            if (this.from != null) {
                this.from.setValue((Object)range.getStart());
            }
            if (this.to != null) {
                this.to.setValue((Object)range.getEnd());
            }
        }
        finally {
            this.inUpdate = false;
        }
    }
}

