/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LinkInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.gui.action.OpenReminderTemplate;
import de.willuhn.jameica.hbci.gui.dialogs.ReminderIntervalDialog;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.reminder.ReminderUtil;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ReminderIntervalInput
implements Input {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Terminable order = null;
    private Input input = null;
    private ReminderIntervalDialog dialog = null;
    private boolean containsInterval = false;
    private Date end = null;

    public ReminderIntervalInput(Terminable terminable, Date termin) throws RemoteException {
        this.order = terminable;
        final HibiscusDBObject bean = (HibiscusDBObject)((Object)this.order);
        if (MetaKey.REMINDER_TEMPLATE.get(bean) != null) {
            this.input = new LinkInput(i18n.tr("von dieser <a>Vorlage</a>"));
            this.input.setName(i18n.tr("Wiederholung"));
            this.input.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        new OpenReminderTemplate().handleAction(ReminderIntervalInput.this.order);
                    }
                    catch (ApplicationException ae) {
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                    }
                }
            });
            return;
        }
        this.containsInterval = true;
        String uuid = MetaKey.REMINDER_UUID.get(bean);
        ReminderInterval ri = null;
        if (uuid != null) {
            try {
                BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
                Reminder reminder = provider.get(uuid);
                if (reminder != null) {
                    ri = reminder.getReminderInterval();
                    this.end = reminder.getEnd();
                }
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RemoteException("unable to load reminder", e);
            }
        }
        this.input = new DialogInput(this.toString(ri, this.end));
        this.input.setName(i18n.tr("Wiederholung"));
        this.input.setValue((Object)ri);
        ((DialogInput)this.input).disableClientControl();
        this.dialog = new ReminderIntervalDialog(ri, termin, this.end, 1);
        this.dialog.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 256) {
                    return;
                }
                ReminderInterval ri = (ReminderInterval)event.data;
                ReminderIntervalInput.this.end = ReminderIntervalInput.this.dialog.getEnd();
                ((DialogInput)ReminderIntervalInput.this.input).setText(ReminderIntervalInput.this.toString(ri, ReminderIntervalInput.this.end));
            }
        });
        ((DialogInput)this.input).setDialog((AbstractDialog)this.dialog);
        if (this.order.ausgefuehrt()) {
            this.input.addListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        if (!ReminderIntervalInput.this.input.hasChanged()) {
                            return;
                        }
                        ReminderInterval ri = (ReminderInterval)ReminderIntervalInput.this.input.getValue();
                        ReminderUtil.apply(bean, ri, ReminderIntervalInput.this.dialog.getEnd());
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(ri != null ? "Wiederholung gespeichert" : "Wiederholung entfernt"), 0));
                    }
                    catch (ApplicationException ae) {
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to apply reminder interval", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
                    }
                }
            });
        }
    }

    private String toString(ReminderInterval ri, Date end) {
        if (ri == null) {
            return "<" + i18n.tr("keine") + ">";
        }
        String text = ri.toString();
        if (end != null) {
            text = String.valueOf(text) + ", " + i18n.tr("bis {0}", HBCI.DATEFORMAT.format(end));
        }
        return text;
    }

    public boolean containsInterval() {
        return this.containsInterval;
    }

    public Object getValue() {
        return this.input.getValue();
    }

    public void setValue(Object value) {
        this.input.setValue(value);
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean hasChanged() {
        return this.input.hasChanged();
    }

    public Control getControl() {
        return this.input.getControl();
    }

    public void addListener(Listener l) {
        this.input.addListener(l);
    }

    public void setComment(String comment) {
        this.input.setComment(comment);
    }

    public void paint(Composite parent) {
        this.input.paint(parent);
        if (!(this.input instanceof DialogInput)) {
            return;
        }
        final DateChangedConsumer mc = new DateChangedConsumer();
        final MessagingQueue queue = Application.getMessagingFactory().getMessagingQueue("hibiscus.termin.changed");
        queue.registerMessageConsumer((MessageConsumer)mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                queue.unRegisterMessageConsumer(mc);
            }
        });
    }

    public void paint(Composite parent, int width) {
        this.input.paint(parent, width);
    }

    public void focus() {
        this.input.focus();
    }

    public void disable() {
        this.input.disable();
    }

    public void enable() {
        this.input.enable();
    }

    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.input.isEnabled();
    }

    public void setMandatory(boolean mandatory) {
        this.input.setMandatory(mandatory);
    }

    public boolean isMandatory() {
        return this.input.isMandatory();
    }

    public void setName(String name) {
        this.input.setName(name);
    }

    public String getName() {
        return this.input.getName();
    }

    public void setData(String key, Object data) {
        this.input.setData(key, data);
    }

    public Object getData(String key) {
        return this.input.getData(key);
    }

    private class DateChangedConsumer
    implements MessageConsumer {
        private DateChangedConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (ReminderIntervalInput.this.dialog == null) {
                return;
            }
            QueryMessage msg = (QueryMessage)message;
            Object data = msg.getData();
            if (!(data instanceof Date)) {
                return;
            }
            ReminderIntervalInput.this.dialog.setDate((Date)data);
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

