/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TerminInput
extends DateInput {
    public static final String QUEUE_TERMIN_CHANGED = "hibiscus.termin.changed";
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Terminable auftrag = null;
    private Listener listener = null;

    public TerminInput(Terminable auftrag) throws RemoteException {
        super(TerminInput.getPreset(auftrag), HBCI.DATEFORMAT);
        this.auftrag = auftrag;
        if (auftrag != null) {
            this.setEnabled(!auftrag.ausgefuehrt());
        }
        this.setName(i18n.tr("Erinnerungstermin"));
        this.setTitle(i18n.tr("Erinnerung"));
        this.setText(i18n.tr("Bitte w\u00e4hlen Sie ein Datum aus, zu dem\nHibiscus Sie an den Auftrag erinnern soll."));
        this.setComment("");
        this.setMandatory(true);
        this.listener = new MyListener();
        this.listener.handleEvent(null);
        this.addListener(this.listener);
    }

    private static Date getPreset(Terminable auftrag) throws RemoteException {
        if (auftrag == null) {
            return new Date();
        }
        Date date = auftrag.getTermin();
        return date != null ? date : new Date();
    }

    public void updateComment() {
        this.listener.handleEvent(null);
    }

    private class MyListener
    implements Listener {
        private MyListener() {
        }

        public void handleEvent(Event event) {
            try {
                if (TerminInput.this.auftrag == null) {
                    return;
                }
                Date date = (Date)TerminInput.this.getValue();
                if (date == null) {
                    date = new Date();
                    TerminInput.this.setValue(date);
                }
                Application.getMessagingFactory().getMessagingQueue(TerminInput.QUEUE_TERMIN_CHANGED).sendMessage((Message)new QueryMessage((Object)date));
                TerminInput.this.auftrag.setTermin(date);
                if (TerminInput.this.auftrag.ausgefuehrt()) {
                    Date ausgefuehrt = TerminInput.this.auftrag.getAusfuehrungsdatum();
                    if (ausgefuehrt != null) {
                        TerminInput.this.setComment(i18n.tr("Am {0} ausgef\u00fchrt", HBCI.DATEFORMAT.format(ausgefuehrt)));
                    } else {
                        TerminInput.this.setComment(i18n.tr("Bereits ausgef\u00fchrt"));
                    }
                } else if (TerminInput.this.auftrag.ueberfaellig()) {
                    TerminInput.this.setComment(i18n.tr("Der Auftrag ist f\u00e4llig"));
                } else {
                    TerminInput.this.setComment("");
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to check overdue", (Throwable)e);
            }
        }
    }
}

