/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.ScaleInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzDaysInput
extends ScaleInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(UmsatzDaysInput.class);
    private static final String TOKEN_DEFAULT = "days";
    private Listener listener = new RangeListener();
    private String token = null;
    private Control c = null;

    public UmsatzDaysInput() {
        super(0);
        this.setValue(UmsatzDaysInput.getDefaultDays() == -1 ? this.getUndefinedMax() : UmsatzDaysInput.getDefaultDays());
        this.setName(i18n.tr("Zeitraum"));
        this.setComment("");
        this.setScaling(1, this.getUndefinedMax(), 1, 10);
        this.addListener(this.listener);
    }

    protected int getUndefinedMax() {
        return 1000;
    }

    public Control getControl() {
        if (this.c != null) {
            return this.c;
        }
        this.c = super.getControl();
        this.c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.setAttribute(UmsatzDaysInput.this.getToken(), ((Integer)UmsatzDaysInput.this.getValue()).intValue());
            }
        });
        this.listener.handleEvent(null);
        return this.c;
    }

    public void setRememberSelection(String s) {
        this.token = s;
        int value = settings.getInt(this.token, HBCIProperties.UMSATZ_DEFAULT_DAYS);
        this.setValue(value == -1 ? this.getUndefinedMax() : value);
    }

    private String getToken() {
        return this.token != null ? this.token : TOKEN_DEFAULT;
    }

    public Object getValue() {
        int i = (Integer)super.getValue();
        if (i >= this.getUndefinedMax()) {
            return -1;
        }
        return i;
    }

    public static final int getDefaultDays() {
        return settings.getInt(TOKEN_DEFAULT, HBCIProperties.UMSATZ_DEFAULT_DAYS);
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.listener.handleEvent(null);
    }

    private class RangeListener
    implements Listener {
        private RangeListener() {
        }

        public void handleEvent(Event event) {
            try {
                int start = (Integer)UmsatzDaysInput.this.getValue();
                if (start == 1) {
                    UmsatzDaysInput.this.setComment(i18n.tr("seit gestern"));
                } else if (start == -1) {
                    UmsatzDaysInput.this.setComment(i18n.tr("Alle Ums\u00e4tze"));
                } else if (start > 0) {
                    long d = (long)start * 24L * 60L * 60L * 1000L;
                    Date date = DateUtil.startOfDay((Date)new Date(System.currentTimeMillis() - d));
                    UmsatzDaysInput.this.setComment(i18n.tr("ab {0} ({1} Tage)", new String[]{HBCI.DATEFORMAT.format(date), Integer.toString(start)}));
                } else {
                    UmsatzDaysInput.this.setComment("");
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to update comment", (Throwable)e);
            }
        }
    }
}

