/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTypBean;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UmsatzTypInput
extends SelectInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private boolean haveComments = false;
    private boolean haveCustomComment = false;
    private boolean haveAutoComment = false;

    public UmsatzTypInput(UmsatzTyp preselected, int typ) throws RemoteException {
        this(preselected, typ, false);
    }

    public UmsatzTypInput(UmsatzTyp preselected, int typ, boolean includeUnassignedType) throws RemoteException {
        this(preselected, null, typ, includeUnassignedType);
    }

    public UmsatzTypInput(UmsatzTyp preselected, UmsatzTyp skip, int typ, boolean unassigned) throws RemoteException {
        super(null, (Object)(preselected != null ? new UmsatzTypBean(preselected) : null));
        ArrayList<UmsatzTypBean> choices = new ArrayList<UmsatzTypBean>(UmsatzTypUtil.getList(skip, typ));
        if (unassigned) {
            choices.add(0, new UmsatzTypBean(UmsatzTypUtil.UNASSIGNED));
        }
        this.setList(choices);
        this.setAttribute("indented");
        this.setName(i18n.tr("Umsatz-Kategorie"));
        this.setPleaseChoose(i18n.tr("<Keine Kategorie>"));
        this.haveComments = Settings.getDBService().execute("select count(id) from umsatztyp where kommentar is not null and kommentar != ''", null, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                return rs.next() && rs.getInt(1) > 0 ? Boolean.TRUE : null;
            }
        }) != null;
        this.refreshComment();
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                UmsatzTypInput.this.refreshComment();
            }
        });
    }

    public void setPreselected(Object preselected) {
        if (preselected instanceof UmsatzTyp) {
            preselected = new UmsatzTypBean((UmsatzTyp)preselected);
        }
        super.setPreselected(preselected);
    }

    public Object getValue() {
        UmsatzTypBean b = (UmsatzTypBean)super.getValue();
        return b != null ? b.getTyp() : null;
    }

    public void setComment(String comment) {
        this.haveCustomComment = StringUtils.trimToNull((String)comment) != null;
        boolean bl = this.haveAutoComment = this.haveComments && comment != null;
        if (!this.haveCustomComment && !this.haveAutoComment) {
            return;
        }
        super.setComment(comment);
    }

    private void refreshComment() {
        if (this.haveCustomComment) {
            return;
        }
        if (!this.haveAutoComment) {
            return;
        }
        try {
            UmsatzTyp ut = (UmsatzTyp)this.getValue();
            if (ut == null) {
                super.setComment("");
                return;
            }
            String comment = ut.getKommentar();
            if (StringUtils.trimToNull((String)comment) == null) {
                super.setComment("");
                return;
            }
            super.setComment(StringUtils.abbreviateMiddle((String)comment, (String)"...", (int)40));
        }
        catch (Exception e) {
            Logger.error((String)"unable to refresh comment", (Throwable)e);
        }
    }
}

