/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.input;

import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ZweckInput
extends TextInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final String VALID = HBCIProperties.HBCI_SEPA_VALIDCHARS;
    private Control control = null;

    public ZweckInput(String value) {
        super(value, HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
        this.setValidChars(VALID);
        this.setName(i18n.tr("Verwendungszweck"));
    }

    public Control getControl() {
        if (this.control != null) {
            return this.control;
        }
        this.control = super.getControl();
        this.control.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                if (e.text == null || e.text.length() == 0) {
                    return;
                }
                String backup = e.text;
                e.text = HBCIProperties.clean(e.text, VALID);
                int diff = backup.length() - e.text.length();
                if (diff > 0) {
                    String msg = diff > 1 ? i18n.tr("Es wurden {0} nicht unterst\u00fctzte Zeichen entfernt", Integer.toString(diff)) : i18n.tr("Es wurde ein nicht unterst\u00fctztes Zeichen entfernt");
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(msg, 2));
                }
            }
        });
        return this.control;
    }
}

