/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.internal.action.Print;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungDelete;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungExecute;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungExport;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungImport;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.action.SepaUeberweisungMerge;
import de.willuhn.jameica.hbci.gui.action.TerminableMarkExecuted;
import de.willuhn.jameica.hbci.io.print.PrintSupportAuslandsUeberweisungList;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class AuslandsUeberweisungList
extends ContextMenu {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public AuslandsUeberweisungList() {
        this.addItem((ContextMenuItem)new SingleItem(i18n.tr("\u00d6ffnen"), new AuslandsUeberweisungNew(), "document-open.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Neue SEPA-\u00dcberweisung..."), (Action)new UNeu(), "text-x-generic.png"));
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("L\u00f6schen..."), (Action)new AuslandsUeberweisungDelete(), "user-trash-full.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new SingleItem(i18n.tr("Duplizieren..."), new Duplicate(), "edit-copy.png"));
        this.addItem((ContextMenuItem)new NotActiveMultiMenuItem(i18n.tr("Zu Sammelauftr\u00e4gen zusammenfassen..."), new SepaUeberweisungMerge(), "sueberweisung.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new NotActiveSingleMenuItem(i18n.tr("Jetzt ausf\u00fchren..."), new AuslandsUeberweisungExecute(), "emblem-important.png"));
        this.addItem((ContextMenuItem)new NotActiveMultiMenuItem(i18n.tr("Als \"ausgef\u00fchrt\" markieren..."), new TerminableMarkExecuted(), "emblem-default.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Drucken..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new Print().handleAction((Object)new PrintSupportAuslandsUeberweisungList(context));
            }
        }, "document-print.png"));
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Exportieren..."), (Action)new AuslandsUeberweisungExport(), "document-save.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Importieren..."), (Action)new AuslandsUeberweisungImport(), "document-open.png"));
    }

    private class NotActiveMultiMenuItem
    extends CheckedContextMenuItem {
        public NotActiveMultiMenuItem(String text, Action a, String icon) {
            super(text, a, icon);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEnabledFor(Object o) {
            if (o == null) return false;
            if (!(o instanceof AuslandsUeberweisung) && !(o instanceof AuslandsUeberweisung[])) {
                return false;
            }
            try {
                if (o instanceof AuslandsUeberweisung) {
                    if (!((AuslandsUeberweisung)o).ausgefuehrt()) return true;
                    return false;
                }
                AuslandsUeberweisung[] t = (AuslandsUeberweisung[])o;
                int i = 0;
                while (true) {
                    if (i >= t.length) {
                        return true;
                    }
                    if (t[i].ausgefuehrt()) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (RemoteException e) {
                Logger.error((String)"unable to check if terminable is already executed", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Pr\u00fcfen, ob Auftrag bereits ausgef\u00fchrt wurde"), 1));
                return false;
            }
        }
    }

    private class NotActiveSingleMenuItem
    extends CheckedContextMenuItem {
        public NotActiveSingleMenuItem(String text, Action a, String icon) {
            super(text, a, icon);
        }

        public boolean isEnabledFor(Object o) {
            block4: {
                if (o == null || !(o instanceof AuslandsUeberweisung)) {
                    return false;
                }
                try {
                    if (!(o instanceof AuslandsUeberweisung[])) break block4;
                    return false;
                }
                catch (Exception e) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Pr\u00fcfen, ob Auftrag bereits ausgef\u00fchrt wurde"), 1));
                    Logger.error((String)"error while enable check in menu item", (Throwable)e);
                    return false;
                }
            }
            AuslandsUeberweisung u = (AuslandsUeberweisung)o;
            return !u.ausgefuehrt();
        }
    }

    private class SingleItem
    extends CheckedContextMenuItem {
        private SingleItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (o instanceof AuslandsUeberweisung[]) {
                return false;
            }
            return super.isEnabledFor(o);
        }
    }

    private class UNeu
    extends AuslandsUeberweisungNew {
        private UNeu() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            super.handleAction(null);
        }
    }
}

