/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerExport;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerImport;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerNew;
import de.willuhn.jameica.hbci.gui.action.SepaConvertAddress;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.gui.action.SepaLastschriftNew;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public class EmpfaengerList
extends ContextMenu
implements Extendable {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public EmpfaengerList() {
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("\u00d6ffnen"), (Action)new EmpfaengerNew(), "document-open.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Neue Adresse..."), (Action)new ENeu(), "contact-new.png"));
        this.addItem((ContextMenuItem)new CheckedHibiscusAddressContextMenuItem(i18n.tr("L\u00f6schen..."), new DBObjectDelete(), "user-trash-full.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Neue \u00dcberweisung..."), (Action)new AuslandsUeberweisungNew(), "ueberweisung.png"));
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Neue Lastschrift..."), (Action)new SepaLastschriftNew(), "lastschrift.png"));
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Neuer Dauerauftrag..."), (Action)new SepaDauerauftragNew(), "dauerauftrag.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Exportieren..."), (Action)new EmpfaengerExport(), "document-save.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Importieren..."), (Action)new EmpfaengerImport(), "document-open.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new SEPAConvertContextMenuItem(i18n.tr("Nach SEPA konvertieren..."), new SepaConvertAddress(), "internet-web-browser.png"));
        ExtensionRegistry.extend((Extendable)this);
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private class CheckedHibiscusAddressContextMenuItem
    extends CheckedContextMenuItem {
        private CheckedHibiscusAddressContextMenuItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (!super.isEnabledFor(o)) {
                return false;
            }
            if (o instanceof HibiscusAddress) {
                return true;
            }
            if (Address[].class.isAssignableFrom(o.getClass())) {
                Address[] list;
                Address[] addressArray = list = (Address[])o;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Address a = addressArray[n2];
                    if (!(a instanceof HibiscusAddress)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
    }

    private class ENeu
    extends EmpfaengerNew {
        private ENeu() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            super.handleAction(null);
        }
    }

    private class SEPAConvertContextMenuItem
    extends CheckedHibiscusAddressContextMenuItem {
        private SEPAConvertContextMenuItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEnabledFor(Object o) {
            if (!super.isEnabledFor(o)) {
                return false;
            }
            try {
                HibiscusAddress[] list;
                if (o instanceof HibiscusAddress) {
                    HibiscusAddress a = (HibiscusAddress)o;
                    String iban = StringUtils.deleteWhitespace((String)a.getIban());
                    return iban == null || iban.length() == 0;
                }
                if (!(o instanceof HibiscusAddress[])) return true;
                HibiscusAddress[] hibiscusAddressArray = list = (HibiscusAddress[])o;
                int n = list.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    HibiscusAddress a = hibiscusAddressArray[n2];
                    String iban = StringUtils.deleteWhitespace((String)a.getIban());
                    if (iban == null || iban.length() == 0) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to check for sepa readyness", (Throwable)re);
            }
            return true;
        }
    }
}

