/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.FlaggableChange;
import de.willuhn.jameica.hbci.gui.action.KontoCopyIBAN;
import de.willuhn.jameica.hbci.gui.action.KontoDelete;
import de.willuhn.jameica.hbci.gui.action.KontoDisable;
import de.willuhn.jameica.hbci.gui.action.KontoExport;
import de.willuhn.jameica.hbci.gui.action.KontoFetchUmsaetze;
import de.willuhn.jameica.hbci.gui.action.KontoImport;
import de.willuhn.jameica.hbci.gui.action.KontoNew;
import de.willuhn.jameica.hbci.gui.action.KontoRecalculateOfflineSaldo;
import de.willuhn.jameica.hbci.gui.action.KontoResetAuszugsdatum;
import de.willuhn.jameica.hbci.gui.action.KontoauszugList;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.gui.action.SepaLastschriftNew;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetailEdit;
import de.willuhn.jameica.hbci.gui.action.UmsatzImport;
import de.willuhn.jameica.hbci.rmi.Flaggable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public class KontoList
extends ContextMenu
implements Extendable {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public KontoList() {
        this(Style.DEFAULT);
    }

    public KontoList(Style style) {
        boolean shortMenu = style != null && style == Style.PASSPORT;
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("\u00d6ffnen"), (Action)new KontoNew(), "document-open.png"));
        if (!shortMenu) {
            this.addItem(new ContextMenuItem(i18n.tr("Neues Konto..."), (Action)new KNeu(), "list-add.png"));
            this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("L\u00f6schen..."), (Action)new KontoDelete(), "user-trash-full.png"));
        }
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Ums\u00e4tze anzeigen..."), (Action)new KontoauszugList(), "text-x-generic.png"));
        this.addItem((ContextMenuItem)new AccountItem(i18n.tr("Saldo/Ums\u00e4tze abrufen..."), new KontoFetchUmsaetze(), "mail-send-receive.png"));
        this.addItem((ContextMenuItem)new CopyIBANContextMenuItem(i18n.tr("IBAN in Zwischenablage kopieren"), new KontoCopyIBAN(), "edit-copy.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        if (!shortMenu) {
            this.addItem((ContextMenuItem)new AccountItem(i18n.tr("Neue \u00dcberweisung..."), new AuslandsUeberweisungNew(), "ueberweisung.png"));
            this.addItem((ContextMenuItem)new AccountItem(i18n.tr("Neue Lastschrift..."), new SepaLastschriftNew(), "lastschrift.png"));
            this.addItem((ContextMenuItem)new AccountItem(i18n.tr("Neuer Dauerauftrag..."), new SepaDauerauftragNew(), "dauerauftrag.png"));
            this.addItem((ContextMenuItem)new AccountItem(i18n.tr("Umsatz anlegen"), new UmsatzDetailEdit(), "emblem-documents.png", true));
            this.addItem(ContextMenuItem.SEPARATOR);
            this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Konten exportieren..."), (Action)new KontoExport(), "document-save.png"));
            this.addItem(new ContextMenuItem(i18n.tr("Konten importieren..."), (Action)new KontoImport(), "document-open.png"));
            this.addItem(new ContextMenuItem(i18n.tr("Ums\u00e4tze importieren..."), (Action)new UmsatzImport(), "document-open.png"));
            this.addItem(ContextMenuItem.SEPARATOR);
        }
        this.addMenu(new ExtendedMenu(style));
        ExtensionRegistry.extend((Extendable)this);
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private class AccountItem
    extends CheckedSingleContextMenuItem {
        private boolean offline;

        private AccountItem(String text, Action a, String icon) {
            this(text, a, icon, false);
        }

        private AccountItem(String text, Action a, String icon, boolean offline) {
            super(text, a, icon);
            this.offline = false;
            this.offline = offline;
        }

        public boolean isEnabledFor(Object o) {
            Konto k;
            block5: {
                block4: {
                    try {
                        if (o != null && o instanceof Konto && super.isEnabledFor(o)) break block4;
                        return false;
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"error while checking flags", (Throwable)re);
                        return false;
                    }
                }
                k = (Konto)o;
                if (!k.hasFlag(1)) break block5;
                return false;
            }
            return k.hasFlag(2) == this.offline;
        }
    }

    private class ChangeFlagsMenuItem
    extends CheckedSingleContextMenuItem {
        boolean f1;

        private ChangeFlagsMenuItem(String title, Action action, String icon, boolean f1) {
            super(title, action, icon);
            this.f1 = false;
            this.f1 = f1;
        }

        public boolean isEnabledFor(Object o) {
            if (o == null || !(o instanceof Flaggable)) {
                return false;
            }
            try {
                boolean f2 = ((Flaggable)o).hasFlag(1);
                return !(this.f1 ^ f2) && super.isEnabledFor(o);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to check flags", (Throwable)re);
                return false;
            }
        }
    }

    private class CopyIBANContextMenuItem
    extends CheckedSingleContextMenuItem {
        private CopyIBANContextMenuItem(String name, Action a, String icon) {
            super(name, a, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (!super.isEnabledFor(o)) {
                return false;
            }
            if (!(o instanceof Konto)) {
                return false;
            }
            try {
                Konto k = (Konto)o;
                String iban = StringUtils.deleteWhitespace((String)k.getIban());
                return iban != null && iban.length() > 0;
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to check account", (Throwable)re);
                return false;
            }
        }
    }

    private class ExtendedMenu
    extends ContextMenu {
        private ExtendedMenu(Style style) {
            this.setText(i18n.tr("Erweitert"));
            this.setImage(SWTUtil.getImage((String)"emblem-symbolic-link.png"));
            boolean shortMenu = style != null && style == Style.PASSPORT;
            this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Saldo und Datum zur\u00fccksetzen..."), (Action)new KontoResetAuszugsdatum(), "edit-undo.png"));
            if (!shortMenu) {
                this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Salden neu berechnen..."), (Action)new KontoRecalculateOfflineSaldo(), "accessories-calculator.png"));
            }
            this.addItem((ContextMenuItem)new ChangeFlagsMenuItem(i18n.tr("Konto deaktivieren..."), new KontoDisable(), "network-offline.png", false));
            this.addItem((ContextMenuItem)new ChangeFlagsMenuItem(i18n.tr("Konto aktivieren..."), new FlaggableChange(1, false), "network-transmit-receive.png", true));
        }
    }

    private class KNeu
    extends KontoNew {
        private KNeu() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            super.handleAction(null);
        }
    }

    public static enum Style {
        PASSPORT,
        DEFAULT;

    }
}

