/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.internal.action.Print;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftExecute;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftExport;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftImport;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftSplit;
import de.willuhn.jameica.hbci.gui.action.TerminableMarkExecuted;
import de.willuhn.jameica.hbci.io.print.PrintSupportSepaSammelLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class SepaSammelLastschriftList
extends ContextMenu {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public SepaSammelLastschriftList() {
        this.addItem((ContextMenuItem)new SingleItem(i18n.tr("\u00d6ffnen"), new SepaSammelLastschriftNew(), "document-open.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Neue SEPA-Sammellastschrift..."), (Action)new SNeu(), "text-x-generic.png"));
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("L\u00f6schen..."), (Action)new DBObjectDelete(), "user-trash-full.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new SingleItem(i18n.tr("Duplizieren..."), new Duplicate(), "edit-copy.png"));
        this.addItem((ContextMenuItem)new NotActiveMultiMenuItem(i18n.tr("In Einzelauftr\u00e4ge teilen..."), new SepaSammelLastschriftSplit(), "lastschrift.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem(new NotActiveMenuItem(i18n.tr("Jetzt ausf\u00fchren..."), new SepaSammelLastschriftExecute(), "emblem-important.png"));
        this.addItem((ContextMenuItem)new NotActiveMultiMenuItem(i18n.tr("Als \"ausgef\u00fchrt\" markieren..."), new TerminableMarkExecuted(), "emblem-default.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Drucken..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new Print().handleAction((Object)new PrintSupportSepaSammelLastschrift((SepaSammelLastschrift)context));
            }
        }, "document-print.png"));
        this.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Exportieren..."), (Action)new SepaSammelLastschriftExport(), "document-save.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Importieren..."), (Action)new SepaSammelLastschriftImport(), "document-open.png"));
    }

    private class NotActiveMenuItem
    extends ContextMenuItem {
        public NotActiveMenuItem(String text, Action a, String icon) {
            super(text, a, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (o == null || !(o instanceof SepaSammelLastschrift)) {
                return false;
            }
            try {
                SepaSammelLastschrift u = (SepaSammelLastschrift)o;
                return !u.ausgefuehrt();
            }
            catch (Exception e) {
                Logger.error((String)"error while enable check in menu item", (Throwable)e);
                return false;
            }
        }
    }

    private class NotActiveMultiMenuItem
    extends CheckedContextMenuItem {
        public NotActiveMultiMenuItem(String text, Action a, String icon) {
            super(text, a, icon);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEnabledFor(Object o) {
            if (o == null) return false;
            if (!(o instanceof Terminable) && !(o instanceof Terminable[])) {
                return false;
            }
            try {
                if (o instanceof Terminable) {
                    if (!((Terminable)o).ausgefuehrt()) return true;
                    return false;
                }
                Terminable[] t = (Terminable[])o;
                int i = 0;
                while (true) {
                    if (i >= t.length) {
                        return true;
                    }
                    if (t[i].ausgefuehrt()) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (RemoteException e) {
                Logger.error((String)"unable to check if terminable is already executed", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Pr\u00fcfen, ob Auftrag bereits ausgef\u00fchrt wurde"), 1));
                return false;
            }
        }
    }

    private class SNeu
    extends SepaSammelLastschriftNew {
        private SNeu() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            super.handleAction(null);
        }
    }

    private class SingleItem
    extends CheckedContextMenuItem {
        private SingleItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (o instanceof SepaSammelLastschrift[]) {
                return false;
            }
            return super.isEnabledFor(o);
        }
    }
}

