/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.internal.action.Print;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerAdd;
import de.willuhn.jameica.hbci.gui.action.UmsatzAssign;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetailEdit;
import de.willuhn.jameica.hbci.gui.action.UmsatzExport;
import de.willuhn.jameica.hbci.gui.action.UmsatzImport;
import de.willuhn.jameica.hbci.gui.action.UmsatzMarkChecked;
import de.willuhn.jameica.hbci.gui.action.UmsatzMarkUnChecked;
import de.willuhn.jameica.hbci.gui.action.UmsatzTypNew;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.parts.UmsatzSetAllReadContextMenuItem;
import de.willuhn.jameica.hbci.gui.parts.UmsatzSetReadContextMenuItem;
import de.willuhn.jameica.hbci.gui.parts.UmsatzSetUnreadContextMenuItem;
import de.willuhn.jameica.hbci.io.print.PrintSupportUmsatzList;
import de.willuhn.jameica.hbci.myema.FibuTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;

public class UmsatzList
extends ContextMenu
implements Extendable {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public UmsatzList() {
        this(null);
    }

    public UmsatzList(final Konto konto) {
        this.addItem((ContextMenuItem)new OpenItem());
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("In Adressbuch \u00fcbernehmen"), new EmpfaengerAdd(), "contact-new.png"));
        this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("Als neue \u00dcberweisung anlegen..."), new AuslandsUeberweisungNew(), "ueberweisung.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new UmsatzBookedItem(i18n.tr("als \"gepr\u00fcft\" markieren..."), new UmsatzMarkChecked(), "emblem-default.png", "ALT+G"));
        this.addItem((ContextMenuItem)new UmsatzBookedItem(i18n.tr("als \"ungepr\u00fcft\" markieren..."), new UmsatzMarkUnChecked(), "edit-undo.png", "CTRL+ALT+G"));
        this.addReverseBookItem();
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("Drucken..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new Print().handleAction((Object)new PrintSupportUmsatzList(context));
            }
        }, "document-print.png"));
        this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("Myema-Transfer"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Umsatz[] umsaetze = null;
                if (context instanceof Umsatz) {
                    umsaetze = new Umsatz[]{(Umsatz)context};
                }
                if (context instanceof Umsatz[]) {
                    Umsatz[] umsaetzeOrg = (Umsatz[])context;
                    umsaetze = new Umsatz[umsaetzeOrg.length];
                    int i = umsaetzeOrg.length;
                    while (i > 0) {
                        umsaetze[umsaetzeOrg.length - i] = umsaetzeOrg[i - 1];
                        --i;
                    }
                }
                if (umsaetze != null && umsaetze.length > 0) {
                    FibuTransfer.execute(umsaetze, true);
                }
            }
        }, "document-save.png"));
        this.addItem((ContextMenuItem)new UmsatzOrGroupItem(i18n.tr("Exportieren..."), new UmsatzExport(), "document-save.png"));
        this.addItem(new ContextMenuItem(i18n.tr("Importieren..."), (Action)new UmsatzImport(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                super.handleAction(konto != null ? konto : context);
            }
        }, "document-open.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("L\u00f6schen..."), new DBObjectDelete(), "user-trash-full.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem((ContextMenuItem)new UmsatzBookedItem(i18n.tr("Kategorie zuordnen..."), new UmsatzAssign(), "x-office-spreadsheet.png", "ALT+K"));
        this.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("Kategorie bearbeiten..."), new UmsatzTypNew(), "document-open.png"){

            public boolean isEnabledFor(Object o) {
                if (o instanceof Umsatz) {
                    try {
                        return ((Umsatz)o).getUmsatzTyp() != null;
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"unable to check umsatztyp", (Throwable)re);
                    }
                }
                return super.isEnabledFor(o);
            }
        });
        this.addItem(new ContextMenuItem(i18n.tr("Neue Kategorie anlegen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                UmsatzTyp ut = null;
                if (context != null) {
                    try {
                        if (context instanceof Umsatz) {
                            Umsatz u = (Umsatz)context;
                            ut = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
                            ut.setName(u.getGegenkontoName());
                            ut.setPattern(u.getZweck());
                        } else if (context instanceof UmsatzTyp) {
                            ut = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
                            ut.setParent((UmsatzTyp)context);
                        } else if (context instanceof UmsatzTreeNode) {
                            ut = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
                            ut.setParent(((UmsatzTreeNode)context).getUmsatzTyp());
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while preparing category", (Throwable)e);
                    }
                }
                new UmsatzTypNew().handleAction(ut);
            }
        }, "text-x-generic.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem(new UmsatzSetAllReadContextMenuItem());
        this.addItem(new UmsatzSetReadContextMenuItem());
        this.addItem(new UmsatzSetUnreadContextMenuItem());
        ExtensionRegistry.extend((Extendable)this);
    }

    private void addReverseBookItem() {
        try {
            List<Konto> konten = KontoUtil.getKonten(KontoFilter.OFFLINE);
            int size = konten.size();
            if (size == 0) {
                return;
            }
            if (size == 1) {
                Konto k = konten.get(0);
                this.addItem((ContextMenuItem)new UmsatzItem(i18n.tr("Gegenbuchung erzeugen auf: {0}", KontoUtil.toString(k)), new UmsatzDetailEdit().asReverse(k), "edit-copy.png"));
                return;
            }
            ContextMenu ctx = new ContextMenu();
            ctx.setText(i18n.tr("Gegenbuchung erzeugen auf..."));
            ctx.setImage(SWTUtil.getImage((String)"edit-copy.png"));
            for (Konto ko : konten) {
                ctx.addItem(new ContextMenuItem(KontoUtil.toString(ko), (Action)new UmsatzDetailEdit().asReverse(ko)));
            }
            this.addMenu(ctx);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while creating reverse booking context menu entry", (Throwable)e);
        }
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private class OpenItem
    extends UmsatzItem {
        private OpenItem() {
            super(i18n.tr("\u00d6ffnen"), new UmsatzDetail(), "document-open.png");
        }

        @Override
        public boolean isEnabledFor(Object o) {
            if (o instanceof Umsatz) {
                return super.isEnabledFor(o);
            }
            return false;
        }
    }

    private class UmsatzBookedItem
    extends UmsatzItem {
        public UmsatzBookedItem(String text, Action action, String icon, String shortcut) {
            super(text, action, icon);
            this.setShortcut(shortcut);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEnabledFor(Object o) {
            if (!(o instanceof Umsatz)) {
                if (!(o instanceof Umsatz[])) return false;
            }
            Umsatz[] umsaetze = null;
            umsaetze = o instanceof Umsatz ? new Umsatz[]{(Umsatz)o} : (Umsatz[])o;
            try {
                int i = 0;
                while (true) {
                    if (i >= umsaetze.length) {
                        return super.isEnabledFor(o);
                    }
                    if (umsaetze[i].hasFlag(2)) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to check for not-booked entries", (Throwable)re);
            }
            return super.isEnabledFor(o);
        }
    }

    private class UmsatzItem
    extends CheckedContextMenuItem {
        public UmsatzItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (o instanceof Umsatz || o instanceof Umsatz[]) {
                return super.isEnabledFor(o);
            }
            return false;
        }
    }

    private class UmsatzOrGroupItem
    extends CheckedContextMenuItem {
        public UmsatzOrGroupItem(String text, Action action, String icon) {
            super(text, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (o instanceof Umsatz || o instanceof Umsatz[]) {
                return super.isEnabledFor(o);
            }
            if (o instanceof UmsatzTreeNode) {
                UmsatzTreeNode node = (UmsatzTreeNode)o;
                return (node.getUmsaetze().size() > 0 || node.getSubGroups().size() > 0) && super.isEnabledFor(o);
            }
            if (o instanceof UmsatzTreeNode[]) {
                UmsatzTreeNode[] umsatzTreeNodeArray = (UmsatzTreeNode[])o;
                int n = umsatzTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UmsatzTreeNode node = umsatzTreeNodeArray[n2];
                    if (node.getUmsaetze().size() > 0 || node.getSubGroups().size() > 0) {
                        return super.isEnabledFor(o);
                    }
                    ++n2;
                }
                return false;
            }
            return false;
        }
    }
}

