/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;

public abstract class AbstractFromToList
extends TablePart
implements Part {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    protected static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private KontoInput konto = null;
    private Input from = null;
    private Input to = null;
    private RangeInput range = null;
    private Input text = null;
    private Container left = null;
    protected Listener listener = null;
    private ButtonArea buttons = new ButtonArea();

    public AbstractFromToList(Action action) {
        super(action);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                AbstractFromToList.this.handleReload(event == null);
            }
        };
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setRememberState(true);
        this.setSummary(true);
        this.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                AbstractFromToList.this.refreshSummary();
            }
        });
    }

    protected String getSummary() {
        try {
            Object o = this.getSelection();
            int size = this.size();
            if (o == null || size == 1 || !(o instanceof Object[])) {
                return super.getSummary();
            }
            Object[] list = (Object[])o;
            BigDecimal sum = this.calculateSum(list);
            if (sum == null) {
                return super.getSummary();
            }
            return i18n.tr("{0} Auftr\u00e4ge, {1} markiert, Summe: {2} {3}", new String[]{Integer.toString(size), Integer.toString(list.length), HBCI.DECIMALFORMAT.format(sum), HBCIProperties.CURRENCY_DEFAULT_DE});
        }
        catch (Exception e) {
            Logger.error((String)"error while updating summary", (Throwable)e);
            return super.getSummary();
        }
    }

    protected BigDecimal calculateSum(Object[] selected) throws RemoteException {
        Transfer[] list;
        if (!(selected instanceof Transfer[])) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        Transfer[] transferArray = list = (Transfer[])selected;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer u = transferArray[n2];
            sum = sum.add(new BigDecimal(u.getBetrag()));
            ++n2;
        }
        return sum;
    }

    private synchronized Input getFrom() {
        if (this.from != null) {
            return this.from;
        }
        this.from = new DateFromInput();
        this.from.setName(i18n.tr("Von"));
        this.from.setComment(null);
        this.from.addListener(this.listener);
        return this.from;
    }

    public Input getText() {
        if (this.text != null) {
            return this.text;
        }
        this.text = new TextInput(settings.getString("transferlist.filter.text", null), 255);
        this.text.setName(i18n.tr("Suchbegriff"));
        return this.text;
    }

    public KontoInput getKonto() throws RemoteException {
        if (this.konto != null) {
            return this.konto;
        }
        this.konto = new KontoInput(null, KontoFilter.ALL);
        this.konto.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.konto.setSupportGroups(true);
        this.konto.setComment(null);
        this.konto.setRememberSelection("auftraege");
        this.konto.addListener(this.listener);
        return this.konto;
    }

    public synchronized Input getTo() {
        if (this.to != null) {
            return this.to;
        }
        this.to = new DateToInput();
        this.to.setName(i18n.tr("bis"));
        this.to.setComment(null);
        this.to.addListener(this.listener);
        return this.to;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getFrom(), this.getTo());
        this.range.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (AbstractFromToList.this.range.getValue() != null && AbstractFromToList.this.range.hasChanged()) {
                    AbstractFromToList.this.handleReload(true);
                }
            }
        });
        return this.range;
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
        this.left = new SimpleContainer(cols.getComposite());
        this.left.addInput((Input)this.getKonto());
        Input t = this.getText();
        this.left.addInput(t);
        t.getControl().addKeyListener((KeyListener)new DelayedAdapter());
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput((Input)this.getRange());
        MultiInput range = new MultiInput(new Input[]{this.getFrom(), this.getTo()});
        right.addInput((Input)range);
        this.buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                AbstractFromToList.this.handleReload(true);
            }
        }, null, true, "view-refresh.png");
        this.buttons.paint(parent);
        DBIterator items = this.getList(this.getKonto().getValue(), (Date)this.getFrom().getValue(), (Date)this.getTo().getValue(), (String)this.getText().getValue());
        if (items != null) {
            items.begin();
            while (items.hasNext()) {
                this.addItem(items.next());
            }
        }
        super.paint(parent);
    }

    protected Container getLeft() {
        return this.left;
    }

    public ButtonArea getButtons() {
        return this.buttons;
    }

    protected abstract DBIterator getList(Object var1, Date var2, Date var3, String var4) throws RemoteException;

    private synchronized void handleReload(boolean force) {
        try {
            final Object konto = this.getKonto().getValue();
            final Date dfrom = (Date)this.getFrom().getValue();
            final Date dto = (Date)this.getTo().getValue();
            final String text = (String)this.getText().getValue();
            if (!force) {
                if (!this.hasChanged()) {
                    return;
                }
                if (dfrom != null && dto != null && dfrom.after(dto)) {
                    GUI.getView().setErrorText(i18n.tr("End-Datum muss sich nach dem Start-Datum befinden"));
                    return;
                }
            }
            GUI.startSync((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractFromToList.this.removeAll();
                        DBIterator items = AbstractFromToList.this.getList(konto, dfrom, dto, text);
                        if (items == null) {
                            return;
                        }
                        items.begin();
                        while (items.hasNext()) {
                            AbstractFromToList.this.addItem(items.next());
                        }
                        AbstractFromToList.this.sort();
                        settings.setAttribute("transferlist.filter.text", text);
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while reloading table", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Tabelle"), 1));
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.error((String)"error while reloading data", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Tabelle"), 1));
        }
    }

    protected boolean hasChanged() {
        return InputCompat.valueHasChanged(new Input[]{this.konto, this.from, this.to, this.text});
    }

    private class DelayedAdapter
    extends KeyAdapter {
        private Listener forward = new DelayedListener(400, new Listener(){

            public void handleEvent(Event event) {
                AbstractFromToList.this.handleReload(true);
            }
        });

        private DelayedAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }
}

