/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.gui.parts.AbstractFromToList;
import de.willuhn.jameica.hbci.gui.parts.columns.AusgefuehrtColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractSepaSammelTransferList
extends AbstractFromToList {
    private MessageConsumer mc = null;
    private CheckboxInput pending = null;

    public AbstractSepaSammelTransferList(Action action) {
        super(action);
        this.setMulti(true);
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        final ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
        final boolean bold = Settings.getBoldValues();
        final CurrencyFormatter f = new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT);
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                SepaSammelTransfer l = (SepaSammelTransfer)item.getData();
                if (l == null) {
                    return;
                }
                try {
                    SepaSammelTransfer o;
                    String uuid;
                    if (bold) {
                        item.setFont(3, Font.BOLD.getSWTFont());
                    }
                    int count = 0;
                    BigDecimal sum = new BigDecimal(0);
                    List list = l.getBuchungen();
                    for (SepaSammelTransferBuchung t : list) {
                        sum = sum.add(new BigDecimal(t.getBetrag()));
                        ++count;
                    }
                    item.setText(2, Integer.toString(count));
                    item.setText(3, f.format((Object)sum));
                    java.util.Date termin = l.getTermin();
                    boolean faellig = l.ueberfaellig() && !l.ausgefuehrt();
                    item.setFont(faellig ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    if (l.ausgefuehrt()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                    if ((uuid = MetaKey.REMINDER_UUID.get(o = l)) != null) {
                        try {
                            Reminder r = provider.get(uuid);
                            item.setImage(4, SWTUtil.getImage((String)"preferences-system-time.png"));
                            item.setText(4, i18n.tr("ab {0}\n{1}", new String[]{HBCI.DATEFORMAT.format(termin), r.getReminderInterval().toString()}));
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to determine reminder", (Throwable)e);
                        }
                    } else if (MetaKey.REMINDER_TEMPLATE.get(o) != null) {
                        item.setImage(4, SWTUtil.getImage((String)"edit-copy.png"));
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to format line", (Throwable)e);
                }
            }
        });
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Bezeichnung"), "bezeichnung");
        this.addColumn(i18n.tr("Anzahl Buchungen"), "dummy", null, false, 131072);
        this.addColumn(i18n.tr("Summe"), "dummy", (Formatter)f, false, 131072);
        this.addColumn(i18n.tr("Termin"), "termin", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(new AusgefuehrtColumn());
        this.mc = new TransferMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    @Override
    protected BigDecimal calculateSum(Object[] selected) throws RemoteException {
        SepaSammelTransfer[] list;
        if (!(selected instanceof SepaSammelTransfer[])) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        SepaSammelTransfer[] sepaSammelTransferArray = list = (SepaSammelTransfer[])selected;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            SepaSammelTransfer u = sepaSammelTransferArray[n2];
            sum = sum.add(u.getSumme());
            ++n2;
        }
        return sum;
    }

    protected CheckboxInput getPending() {
        if (this.pending != null) {
            return this.pending;
        }
        this.pending = new CheckboxInput(settings.getBoolean("transferlist.filter.pending", false));
        this.pending.setName(i18n.tr("Nur offene Auftr\u00e4ge anzeigen"));
        this.pending.addListener(this.listener);
        this.pending.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("transferlist.filter.pending", ((Boolean)AbstractSepaSammelTransferList.this.pending.getValue()).booleanValue());
            }
        });
        return this.pending;
    }

    @Override
    protected boolean hasChanged() {
        return InputCompat.valueHasChanged(super.hasChanged(), new Input[]{this.pending});
    }

    @Override
    protected DBIterator getList(Object konto, java.util.Date from, java.util.Date to, String text) throws RemoteException {
        boolean pending;
        int filterCount = 0;
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(this.getObjectType());
        if (from != null) {
            list.addFilter("termin >= ?", new Object[]{new Date(DateUtil.startOfDay((java.util.Date)from).getTime())});
            ++filterCount;
        }
        if (to != null) {
            list.addFilter("termin <= ?", new Object[]{new Date(DateUtil.endOfDay((java.util.Date)to).getTime())});
            ++filterCount;
        }
        if (text != null && text.length() > 0) {
            list.addFilter("LOWER(bezeichnung) like ?", new Object[]{"%" + text.toLowerCase() + "%"});
            ++filterCount;
        }
        if (konto != null) {
            if (konto instanceof Konto) {
                list.addFilter("konto_id = " + ((Konto)konto).getID());
            } else if (konto instanceof String) {
                list.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{(String)konto});
            }
            ++filterCount;
        }
        if (pending = ((Boolean)this.getPending().getValue()).booleanValue()) {
            list.addFilter("ausgefuehrt = 0");
            ++filterCount;
        }
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC, id DESC");
        if (filterCount > 0) {
            int size;
            int all = service.createList(this.getObjectType()).size();
            if (all != (size = list.size())) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Suchkriterien: {0} - Anzeige: {1} von {2} Auftr\u00e4gen", new String[]{Integer.toString(filterCount), Integer.toString(size), Integer.toString(all)}), 2));
            } else {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Suchkriterien: {0}", Integer.toString(filterCount)), 2));
            }
        }
        return list;
    }

    protected abstract Class getObjectType();

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(AbstractSepaSammelTransferList.this.mc);
            }
        });
        super.paint(parent);
        this.getLeft().addInput((Input)this.getPending());
    }

    public class TransferMessageConsumer
    implements MessageConsumer {
        private DelayedListener insertDelay = null;
        private DelayedListener updateDelay = null;

        private TransferMessageConsumer() {
            if (AbstractSepaSammelTransferList.this.listener != null) {
                this.insertDelay = new DelayedListener(AbstractSepaSammelTransferList.this.listener);
            }
            this.updateDelay = new DelayedListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        Object o = event.data;
                        if (o != null) {
                            AbstractSepaSammelTransferList.this.updateItem(o, o);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update item", (Throwable)e);
                    }
                }
            });
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (!(o instanceof SepaSammelTransfer) && !(o instanceof SepaSammelTransferBuchung)) {
                return;
            }
            if (message instanceof ObjectChangedMessage) {
                Event e = new Event();
                e.data = o;
                this.updateDelay.handleEvent(e);
                return;
            }
            if (this.insertDelay != null) {
                this.insertDelay.handleEvent(null);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

