/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.gui.parts.AbstractFromToList;
import de.willuhn.jameica.hbci.gui.parts.columns.AusgefuehrtColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.BlzColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.sql.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTransferList
extends AbstractFromToList {
    private MessageConsumer mc = null;
    private CheckboxInput pending = null;

    public AbstractTransferList(Action action) {
        super(action);
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        final ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                block10: {
                    Terminable l = (Terminable)item.getData();
                    if (l == null) {
                        return;
                    }
                    try {
                        HibiscusDBObject o;
                        String uuid;
                        if (bold) {
                            item.setFont(4, Font.BOLD.getSWTFont());
                        }
                        java.util.Date termin = l.getTermin();
                        boolean faellig = l.ueberfaellig() && !l.ausgefuehrt();
                        item.setFont(faellig ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                        if (l.ausgefuehrt()) {
                            item.setForeground(Color.COMMENT.getSWTColor());
                        }
                        if ((uuid = MetaKey.REMINDER_UUID.get(o = (HibiscusDBObject)((Object)l))) != null) {
                            try {
                                Reminder r = provider.get(uuid);
                                item.setImage(5, SWTUtil.getImage((String)"preferences-system-time.png"));
                                java.util.Date end = r.getEnd();
                                if (end != null) {
                                    item.setText(5, i18n.tr("{0} - {1} \n{2}", new String[]{HBCI.DATEFORMAT.format(termin), HBCI.DATEFORMAT.format(end), r.getReminderInterval().toString()}));
                                    break block10;
                                }
                                item.setText(5, i18n.tr("ab {0} \n{1}", new String[]{HBCI.DATEFORMAT.format(termin), r.getReminderInterval().toString()}));
                            }
                            catch (Exception e) {
                                Logger.error((String)"unable to determine reminder", (Throwable)e);
                            }
                            break block10;
                        }
                        if (MetaKey.REMINDER_TEMPLATE.get(o) != null) {
                            item.setImage(5, SWTUtil.getImage((String)"edit-copy.png"));
                        }
                    }
                    catch (RemoteException e) {
                        Logger.error((String)"unable to format line", (Throwable)e);
                    }
                }
            }
        });
        this.initColums();
        this.setMulti(true);
        this.mc = new TransferMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    protected void initColums() {
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Gegenkonto Inhaber"), "empfaenger_name");
        this.addColumn(new BlzColumn("empfaenger_blz", i18n.tr("Gegenkonto BLZ")));
        this.addColumn(i18n.tr("Verwendungszweck"), "mergedzweck");
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(i18n.tr("Termin"), "termin", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(new AusgefuehrtColumn());
    }

    protected CheckboxInput getPending() {
        if (this.pending != null) {
            return this.pending;
        }
        this.pending = new CheckboxInput(settings.getBoolean("transferlist.filter.pending", false));
        this.pending.setName(i18n.tr("Nur offene Auftr\u00e4ge anzeigen"));
        this.pending.addListener(this.listener);
        this.pending.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("transferlist.filter.pending", ((Boolean)AbstractTransferList.this.pending.getValue()).booleanValue());
            }
        });
        return this.pending;
    }

    @Override
    protected boolean hasChanged() {
        return InputCompat.valueHasChanged(super.hasChanged(), new Input[]{this.pending});
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(AbstractTransferList.this.mc);
            }
        });
        super.paint(parent);
        this.getLeft().addInput((Input)this.getPending());
    }

    @Override
    protected DBIterator getList(Object konto, java.util.Date from, java.util.Date to, String text) throws RemoteException {
        boolean pending;
        int filterCount = 0;
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(this.getObjectType());
        if (from != null) {
            list.addFilter("termin >= ?", new Object[]{new Date(DateUtil.startOfDay((java.util.Date)from).getTime())});
            ++filterCount;
        }
        if (to != null) {
            list.addFilter("termin <= ?", new Object[]{new Date(DateUtil.endOfDay((java.util.Date)to).getTime())});
            ++filterCount;
        }
        if (konto != null) {
            if (konto instanceof Konto) {
                list.addFilter("konto_id = " + ((Konto)konto).getID());
            } else if (konto instanceof String) {
                list.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{(String)konto});
            }
            ++filterCount;
        }
        if (pending = ((Boolean)this.getPending().getValue()).booleanValue()) {
            list.addFilter("ausgefuehrt = 0");
            ++filterCount;
        }
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC, id DESC");
        if (filterCount > 0) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Suchkriterien: {0}", Integer.toString(filterCount)), 2));
        }
        return list;
    }

    protected abstract Class getObjectType();

    public class TransferMessageConsumer
    implements MessageConsumer {
        private DelayedListener delayed = null;

        private TransferMessageConsumer() {
            if (AbstractTransferList.this.listener != null) {
                this.delayed = new DelayedListener(AbstractTransferList.this.listener);
            }
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            final GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (!AbstractTransferList.this.getObjectType().isAssignableFrom(o.getClass())) {
                return;
            }
            if (message instanceof ObjectChangedMessage) {
                GUI.startSync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractTransferList.this.updateItem(o, o);
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to update item", (Throwable)e);
                        }
                    }
                });
                return;
            }
            if (this.delayed != null) {
                this.delayed.handleEvent(null);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

