/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.parts.AbstractTransferList;
import de.willuhn.jameica.hbci.gui.parts.columns.AusgefuehrtColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import java.rmi.RemoteException;
import java.util.Date;

public class AuslandsUeberweisungList
extends AbstractTransferList {
    public AuslandsUeberweisungList(Action action) throws RemoteException {
        super(action);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.AuslandsUeberweisungList());
    }

    @Override
    protected void initColums() {
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Gegenkonto Inhaber"), "empfaenger_name");
        this.addColumn(i18n.tr("Gegenkonto BIC"), "empfaenger_bic");
        this.addColumn(i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(i18n.tr("Termin"), "termin", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(new AusgefuehrtColumn());
    }

    @Override
    protected Class getObjectType() {
        return AuslandsUeberweisung.class;
    }

    @Override
    protected DBIterator getList(Object konto, Date from, Date to, String text) throws RemoteException {
        DBIterator list = super.getList(konto, from, to, text);
        if (text != null && text.length() > 0) {
            String s = "%" + text.toLowerCase() + "%";
            list.addFilter("(LOWER(empfaenger_konto) like ? or LOWER(empfaenger_name) like ? or LOWER(zweck) like ?)", new Object[]{s, s, s});
        }
        return list;
    }
}

