/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.parts.columns.BlzColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.rmi.Dauerauftrag;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.TableItem;

public class DauerauftragList
extends TablePart
implements Part {
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public DauerauftragList(Action action) throws RemoteException {
        super((GenericIterator)Settings.getDBService().createList(Dauerauftrag.class), action);
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    if (item == null || item.getData() == null) {
                        return;
                    }
                    Dauerauftrag d = (Dauerauftrag)item.getData();
                    if (d.getLetzteZahlung() != null && new Date().after(d.getLetzteZahlung())) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while checking finish date", (Throwable)e);
                    GUI.getStatusBar().setErrorText(DauerauftragList.this.i18n.tr("Fehler beim Pr\u00fcfen des Ablaufdatums eines Dauerauftrages"));
                }
            }
        });
        this.addColumn(new KontoColumn());
        this.addColumn(this.i18n.tr("Gegenkonto Inhaber"), "empfaenger_name");
        this.addColumn(new BlzColumn("empfaenger_blz", this.i18n.tr("Gegenkonto BLZ")));
        this.addColumn(this.i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(this.i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(this.i18n.tr("Turnus"), "turnus_id");
        this.addColumn(this.i18n.tr("N\u00e4chste Zahlung"), "naechste_zahlung", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(this.i18n.tr("aktiv?"), "orderid", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return "nein";
                }
                String s = o.toString();
                if (s != null && s.length() > 0) {
                    return DauerauftragList.this.i18n.tr("ja");
                }
                return DauerauftragList.this.i18n.tr("nein");
            }
        });
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.DauerauftragList());
    }
}

