/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.VergleichBarChart;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class EinnahmenAusgabenVerlauf
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private VergleichBarChart chart = null;
    private List<EinnahmeAusgabeZeitraum> data = null;

    public EinnahmenAusgabenVerlauf(List<EinnahmeAusgabeZeitraum> werte) {
        this.data = werte;
    }

    public void paint(Composite parent) throws RemoteException {
        try {
            this.chart = new VergleichBarChart();
            this.chart.setTitle(i18n.tr("Einnahmen und Ausgaben im Vergleich"));
            this.chart.setData(this.data);
            this.chart.paint(parent);
        }
        catch (Exception e) {
            Logger.error((String)"unable to create chart", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erzeugen des Diagramms"), 1));
        }
    }

    public void setList(List<EinnahmeAusgabeZeitraum> werte) throws RemoteException {
        this.data = werte;
        this.chart.setData(werte);
        this.chart.redraw();
    }
}

