/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerNew;
import de.willuhn.jameica.hbci.gui.filter.AddressFilter;
import de.willuhn.jameica.hbci.gui.formatter.IbanFormatter;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Addressbook;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TableItem;

public class EmpfaengerList
extends TablePart
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Addressbook book = null;
    private TextInput search = null;
    private KeyAdapter listener = null;
    private AddressFilter filter = null;
    private boolean createButton = true;
    private MessageConsumer mcImport = null;
    private MessageConsumer mcChanged = null;
    private static Settings mySettings = new Settings(EmpfaengerList.class);

    public EmpfaengerList(Action action) throws RemoteException {
        this(action, null);
    }

    public EmpfaengerList(Action action, AddressFilter filter) throws RemoteException {
        this(action, filter, true);
    }

    public EmpfaengerList(Action action, AddressFilter filter, boolean createButton) throws RemoteException {
        super(action);
        this.filter = filter;
        this.listener = new DelayedAdapter();
        this.createButton = createButton;
        this.addColumn(i18n.tr("Name"), "name");
        this.addColumn(i18n.tr("Kontonummer"), "kontonummer");
        this.addColumn(i18n.tr("Bankleitzahl"), "blz", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                try {
                    String blz = o.toString();
                    String name = HBCIProperties.getNameForBank(blz);
                    if (name == null || name.length() == 0) {
                        return blz;
                    }
                    return String.valueOf(blz) + " [" + name + "]";
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting blz", (Throwable)e);
                    return o.toString();
                }
            }
        });
        this.addColumn(i18n.tr("IBAN"), "iban", new IbanFormatter());
        this.addColumn(i18n.tr("Gruppe"), "kategorie");
        this.addColumn(i18n.tr("Notiz"), "kommentar", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                String s = o.toString();
                if ((s = s.replaceAll("\\n|\\r", ", ")).length() < 30) {
                    return s;
                }
                return String.valueOf(s.substring(0, 29)) + "...";
            }
        });
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    Object o = item.getData();
                    if (o == null || !(o instanceof Address)) {
                        return;
                    }
                    if (o instanceof HibiscusAddress) {
                        item.setForeground(Color.FOREGROUND.getSWTColor());
                    } else {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to format address", (Throwable)e);
                }
            }
        });
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.EmpfaengerList());
        this.setMulti(true);
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setRememberState(true);
        this.mcImport = new EmpfaengerImportMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mcImport);
        this.mcChanged = new EmpfaengerChangedMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mcChanged);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        try {
            AddressbookService service = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
            this.book = service;
            if (service.hasExternalAddressbooks()) {
                final SelectInput select = new SelectInput((Object[])service.getAddressbooks(), null);
                select.setAttribute("name");
                select.addListener(new Listener(){

                    public void handleEvent(Event event) {
                        Object value = select.getValue();
                        if (value == null || !(value instanceof Addressbook)) {
                            return;
                        }
                        EmpfaengerList.this.book = (Addressbook)value;
                        EmpfaengerList.this.reload();
                    }
                });
                tab.addLabelPair(i18n.tr("Adressbuch"), (Input)select);
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to load addressbook service", e);
        }
        this.search = new TextInput(mySettings.getString("search", null));
        tab.addLabelPair(i18n.tr("Suchbegriff"), (Input)this.search);
        this.search.getControl().addKeyListener((KeyListener)this.listener);
        if (this.createButton) {
            ButtonArea buttons = new ButtonArea();
            buttons.addButton(i18n.tr("Neue Adresse"), (Action)new EmpfaengerNew(), null, true, "contact-new.png");
            buttons.paint(parent);
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(EmpfaengerList.this.mcImport);
                Application.getMessagingFactory().unRegisterMessageConsumer(EmpfaengerList.this.mcChanged);
            }
        });
        this.reload();
        super.paint(parent);
        super.sort();
    }

    private synchronized void reload() {
        GUI.startSync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    EmpfaengerList.this.removeAll();
                    String text = (String)EmpfaengerList.this.search.getValue();
                    mySettings.setAttribute("search", text);
                    List found = EmpfaengerList.this.book.findAddresses(text);
                    if (found == null) {
                        return;
                    }
                    int i = 0;
                    while (i < found.size()) {
                        Address a = (Address)found.get(i);
                        if (EmpfaengerList.this.filter == null || EmpfaengerList.this.filter.accept(a)) {
                            EmpfaengerList.this.addItem(a);
                        }
                        ++i;
                    }
                    EmpfaengerList.this.sort();
                }
                catch (Exception e) {
                    Logger.error((String)"error while reloading addresses", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Laden der Adressen"), 1));
                }
            }
        });
    }

    private class DelayedAdapter
    extends KeyAdapter {
        private Listener forward = new DelayedListener(700, new Listener(){

            public void handleEvent(Event event) {
                EmpfaengerList.this.reload();
            }
        });

        private DelayedAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }

    private class EmpfaengerChangedMessageConsumer
    implements MessageConsumer {
        private EmpfaengerChangedMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ObjectMessage m = (ObjectMessage)message;
                        GenericObject o = m.getObject();
                        EmpfaengerList.this.updateItem(o, o);
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update address", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }

    public class EmpfaengerImportMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null || !(message instanceof ImportMessage)) {
                return;
            }
            GenericObject o = ((ImportMessage)message).getObject();
            if (o == null || !(o instanceof Address)) {
                return;
            }
            if (EmpfaengerList.this.listener != null) {
                EmpfaengerList.this.listener.keyReleased(null);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

