/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.ScrolledContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class ErweiterteVerwendungszwecke
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String[] orig = null;
    private List<TextInput> fields = new ArrayList<TextInput>();
    private Button add = null;
    private boolean readonly = false;
    private Konto konto = null;
    private boolean haveFocus = false;

    public ErweiterteVerwendungszwecke(HibiscusTransfer transfer) throws RemoteException {
        this.konto = transfer.getKonto();
        this.readonly = transfer instanceof Terminable && ((Terminable)((Object)transfer)).ausgefuehrt();
        this.orig = transfer.getWeitereVerwendungszwecke();
    }

    public ErweiterteVerwendungszwecke(SammelTransferBuchung buchung) throws RemoteException {
        SammelTransfer tf = buchung.getSammelTransfer();
        this.konto = tf.getKonto();
        this.readonly = tf.ausgefuehrt();
        this.orig = buchung.getWeitereVerwendungszwecke();
    }

    public void paint(Composite parent) throws RemoteException {
        this.fields.clear();
        final int maxusage = VerwendungszweckUtil.getMaxUsageUeb(this.konto);
        Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
        int size = settings.getInt("transfertype.usagelist.size", 5);
        if (this.orig != null && this.orig.length > size) {
            size = this.orig.length;
        }
        final ScrolledContainer container = new ScrolledContainer(parent);
        int i = 0;
        while (i < size) {
            this.createLine((Container)container, this.orig != null && this.orig.length > i ? this.orig[i] : null, i, this.readonly);
            ++i;
        }
        this.add = new Button("  +  ", new Action(){

            public void handleAction(Object context) throws ApplicationException {
                int size = ErweiterteVerwendungszwecke.this.fields.size();
                ErweiterteVerwendungszwecke.this.createLine((Container)container, null, size, ErweiterteVerwendungszwecke.this.readonly);
                container.update();
                ErweiterteVerwendungszwecke.this.add.setEnabled(!ErweiterteVerwendungszwecke.this.readonly && size + 3 < maxusage);
            }
        });
        this.add.setEnabled(!this.readonly && size + 3 <= maxusage);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.add);
        buttons.paint(parent);
        container.update();
    }

    private void createLine(Container container, String text, int pos, boolean readonly) {
        TextInput zweck = new TextInput(text, HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        zweck.setEnabled(!readonly);
        zweck.setName(i18n.tr("Verwendungszweck {0}", "" + (pos + 3)));
        zweck.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        if (!(this.haveFocus || text != null && text.length() != 0)) {
            zweck.focus();
            this.haveFocus = true;
        }
        container.addInput((Input)zweck);
        this.fields.add(zweck);
    }

    public String[] getTexts() throws RemoteException {
        ArrayList<String> list = new ArrayList<String>();
        for (TextInput text : this.fields) {
            String value = (String)text.getValue();
            if (value == null || (value = value.trim()).length() == 0) continue;
            list.add(value);
        }
        this.orig = list.toArray(new String[0]);
        return this.orig;
    }
}

