/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.PassportRegistry;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.action.KontoFetchFromPassport;
import de.willuhn.jameica.hbci.gui.action.KontoNew;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoartInput;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TableItem;

public class KontoList
extends TablePart
implements Part,
Extendable {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private TextInput search = null;
    private CheckboxInput onlyActive = null;
    private SelectInput accountType = null;
    private MessageConsumer mc = null;
    private boolean showFilter = true;
    private Listener listener = new MyListener();
    private KeyListener delayed = new MyDelayedListener();

    public KontoList(List<Konto> konten, Action action) {
        super(konten, action);
        this.addFeature((Feature)new FeatureSummary());
        this.addColumn(i18n.tr("Kontonummer"), "kontonummer", null, false, 131072);
        this.addColumn(i18n.tr("Bankleitzahl"), "blz", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                try {
                    String blz = o.toString();
                    String name = HBCIProperties.getNameForBank(blz);
                    if (name == null || name.length() == 0) {
                        return blz;
                    }
                    return String.valueOf(blz) + " [" + name + "]";
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting blz", (Throwable)e);
                    return o.toString();
                }
            }
        });
        this.addColumn(i18n.tr("Bezeichnung"), "bezeichnung");
        this.addColumn(i18n.tr("Gruppe"), "kategorie");
        this.addColumn(i18n.tr("Notiz"), "kommentar");
        this.addColumn(i18n.tr("Verfahren"), "passport_class", new Formatter(){

            public String format(Object o) {
                if (o == null || !(o instanceof String)) {
                    return null;
                }
                try {
                    Passport p = PassportRegistry.findByClass((String)o);
                    return p.getName();
                }
                catch (Exception e) {
                    Logger.error((String)"error while loading hbci passport for konto", (Throwable)e);
                    return i18n.tr("Fehler beim Ermitteln des Verfahrens");
                }
            }
        });
        this.addColumn(i18n.tr("Saldo"), "saldo", null, false, 131072);
        this.addColumn(i18n.tr("Verf\u00fcgbar"), "saldo_available", null, false, 131072);
        this.addColumn(i18n.tr("Saldo aktualisiert am"), "saldo_datum", (Formatter)new DateFormatter(HBCI.LONGDATEFORMAT));
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Konto k = (Konto)item.getData();
                int saldocolumn = 6;
                try {
                    double saldo = k.getSaldo();
                    if (saldo == 0.0 && k.getSaldoDatum() == null || Double.isNaN(saldo)) {
                        item.setText(6, "");
                    } else {
                        item.setText(6, String.valueOf(HBCI.DECIMALFORMAT.format(saldo)) + " " + k.getWaehrung());
                    }
                    double avail = k.getSaldoAvailable();
                    if (avail == 0.0 && k.getSaldoDatum() == null || Double.isNaN(avail)) {
                        item.setText(7, "");
                    } else {
                        item.setText(7, String.valueOf(HBCI.DECIMALFORMAT.format(avail)) + " " + k.getWaehrung());
                    }
                    if (bold) {
                        item.setFont(6, Font.BOLD.getSWTFont());
                    }
                    item.setForeground(7, ColorUtil.getForeground(k.getSaldoAvailable()));
                    if (k.hasFlag(1)) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    } else if (k.hasFlag(2)) {
                        item.setForeground(Color.LINK.getSWTColor());
                    } else {
                        item.setForeground(Color.FOREGROUND.getSWTColor());
                    }
                    item.setForeground(6, ColorUtil.getForeground(k.getSaldo()));
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while formatting saldo", (Throwable)e);
                }
            }
        });
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.KontoList());
        this.setMulti(true);
        this.mc = new SaldoMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
        this.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                KontoList.this.featureEvent(Feature.Event.REFRESH, null);
            }
        });
        ExtensionRegistry.extend((Extendable)this);
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void setShowFilter(boolean b) {
        this.showFilter = b;
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        if (this.showFilter) {
            this.reload();
            TabFolder folder = new TabFolder(parent, 0);
            folder.setLayoutData((Object)new GridData(768));
            TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
            ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
            SimpleContainer c = new SimpleContainer(cols.getComposite());
            TextInput search = this.getText();
            c.addInput((Input)search);
            search.getControl().addKeyListener(this.delayed);
            c.addInput((Input)this.getActiveOnly());
            c = new SimpleContainer(cols.getComposite());
            c.addInput((Input)this.getAccountType());
            ButtonArea buttons = new ButtonArea();
            buttons.addButton(i18n.tr("Konten \u00fcber den Bank-Zugang importieren..."), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    new KontoFetchFromPassport().handleAction(KontoList.this.getSelection());
                }
            }, null, false, "mail-send-receive.png");
            buttons.addButton(i18n.tr("Konto manuell anlegen"), (Action)new KontoNew(), null, false, "list-add.png");
            buttons.paint(parent);
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(KontoList.this.mc);
            }
        });
        super.paint(parent);
    }

    private TextInput getText() {
        if (this.search != null) {
            return this.search;
        }
        this.search = new TextInput(settings.getString("kontolist.filter.text", null), 255);
        this.search.setName(i18n.tr("Suchbegriff"));
        return this.search;
    }

    private CheckboxInput getActiveOnly() {
        if (this.onlyActive != null) {
            return this.onlyActive;
        }
        this.onlyActive = new CheckboxInput(settings.getBoolean("kontolist.filter.active", false));
        this.onlyActive.setName(i18n.tr("Nur aktive Konten"));
        this.onlyActive.addListener(this.listener);
        return this.onlyActive;
    }

    private SelectInput getAccountType() {
        if (this.accountType != null) {
            return this.accountType;
        }
        this.accountType = new KontoartInput(settings.getInt("kontolist.filter.type", -1));
        this.accountType.addListener(this.listener);
        return this.accountType;
    }

    private void reload() {
        GUI.startSync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    KontoList.this.removeAll();
                    List<Konto> konten = KontoList.this.getList();
                    if (konten == null) {
                        return;
                    }
                    for (Konto k : konten) {
                        KontoList.this.addItem(k);
                    }
                    KontoList.this.sort();
                }
                catch (Exception e) {
                    Logger.error((String)"error while reloading table", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Tabelle"), 1));
                }
            }
        });
    }

    private List<Konto> getList() throws RemoteException {
        String text = (String)this.getText().getValue();
        boolean activeOnly = (Boolean)this.getActiveOnly().getValue();
        Integer type = (Integer)this.getAccountType().getValue();
        Integer flags = activeOnly ? Integer.valueOf(1) : null;
        List<Konto> list = KontoUtil.getKonten(KontoFilter.SEARCH(text, flags, type));
        settings.setAttribute("kontolist.filter.text", text);
        settings.setAttribute("kontolist.filter.active", activeOnly);
        settings.setAttribute("kontolist.filter.type", type != null ? type : -1);
        return list;
    }

    protected Feature.Context createFeatureEventContext(Feature.Event e, Object data) {
        Feature.Context ctx = super.createFeatureEventContext(e, data);
        if (this.hasEvent(FeatureSummary.class, e)) {
            ctx.addon.put("summary.text", this.getSummaryText());
        }
        return ctx;
    }

    private String getSummaryText() {
        try {
            List<Konto> items = null;
            Object o = this.getSelection();
            boolean selected = o != null && o instanceof Konto[];
            items = selected ? Arrays.asList((Konto[])o) : this.getItems();
            double sum = 0.0;
            for (Konto k : items) {
                sum += k.getSaldo();
            }
            if (selected) {
                return i18n.tr("{0} Konten markiert, Gesamt-Saldo: {1} {2}", new String[]{Integer.toString(items.size()), HBCI.DECIMALFORMAT.format(sum), HBCIProperties.CURRENCY_DEFAULT_DE});
            }
            return i18n.tr("Gesamt-Saldo: {0} {1}", new String[]{HBCI.DECIMALFORMAT.format(sum), HBCIProperties.CURRENCY_DEFAULT_DE});
        }
        catch (Exception ex) {
            Logger.error((String)"error while updating summary", (Throwable)ex);
            return null;
        }
    }

    private class MyDelayedListener
    extends KeyAdapter {
        private Listener forward;

        private MyDelayedListener() {
            this.forward = new DelayedListener(700, KontoList.this.listener);
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }

    private class MyListener
    implements Listener {
        private MyListener() {
        }

        public void handleEvent(Event event) {
            KontoList.this.reload();
        }
    }

    public class SaldoMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{SaldoMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            final GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null || !(o instanceof Konto)) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int index = KontoList.this.removeItem(o);
                        if (index == -1) {
                            return;
                        }
                        KontoList.this.addItem(o, index);
                        Object prev = KontoList.this.getSelection();
                        if (prev != null && prev == o) {
                            KontoList.this.select(o);
                        }
                        KontoList.this.featureEvent(Feature.Event.REFRESH, null);
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

