/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.DecimalInput;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.KontoFetchUmsaetze;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.gui.action.UmsatzExport;
import de.willuhn.jameica.hbci.gui.dialogs.AdresseAuswahlDialog;
import de.willuhn.jameica.hbci.gui.dialogs.UmsatzTypNewDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.formatter.IbanFormatter;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.gui.input.UmsatzTypInput;
import de.willuhn.jameica.hbci.gui.parts.UmsatzList;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

public class KontoauszugList
extends UmsatzList {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(KontoauszugList.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings syssettings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private UmsatzTyp searchTyp = null;
    private SearchInput search = null;
    private CheckboxInput regex = null;
    private TextInput text = null;
    private CheckboxInput unchecked = null;
    private KontoInput kontoAuswahl = null;
    private DateInput start = null;
    private DateInput end = null;
    private RangeInput range = null;
    private UmsatzTypInput kategorie = null;
    private CheckboxInput subKategorien = null;
    private DialogInput gegenkontoNummer = null;
    private TextInput gegenkontoName = null;
    private TextInput gegenkontoBLZ = null;
    private DecimalInput betragFrom = null;
    private DecimalInput betragTo = null;
    private Listener listener = null;
    private boolean disposed = false;
    private boolean changed = false;
    private int filterCount = 0;

    public KontoauszugList() throws RemoteException {
        super((GenericIterator<Umsatz>)null, (Action)new UmsatzDetail());
        this.setFilterVisible(false);
        this.searchTyp = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
        this.listener = new DelayedListener(700, new Listener(){

            public void handleEvent(Event event) {
                KontoauszugList.this.handleReload(false);
            }
        });
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("GK IBAN"), "empfaenger_konto", new IbanFormatter());
        this.addColumn(i18n.tr("GK BIC"), "empfaenger_blz");
        this.addColumn(i18n.tr("Art"), "art");
        final TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(768));
        Object tab = new TabGroup(folder, i18n.tr("Suchbegriff"));
        SimpleContainer c = new SimpleContainer(tab.getComposite());
        c.addInput((Input)this.getSearch());
        c.addCheckbox(this.getRegex(), i18n.tr("Suchbegriff ist ein regul\u00e4rer Ausdruck"));
        c.addCheckbox(this.getUnChecked(), i18n.tr("Nur ungepr\u00fcfte Ums\u00e4tze"));
        tab = new TabGroup(folder, i18n.tr("Konto/Kategorie/Zeitraum"));
        ColumnLayout columns = new ColumnLayout(tab.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addLabelPair(i18n.tr("Konto"), (Input)this.getKontoAuswahl());
        left.addLabelPair(i18n.tr("Kategorie"), (Input)this.getKategorie());
        left.addCheckbox(this.getSubKategorien(), i18n.tr("Untergeordnete Kategorien einbeziehen"));
        SimpleContainer right = new SimpleContainer(columns.getComposite());
        right.addInput((Input)this.getRange());
        MultiInput range = new MultiInput(new Input[]{this.getStart(), this.getEnd()});
        right.addInput((Input)range);
        tab = new TabGroup(folder, i18n.tr("Gegenkonto/Zweck/Betrag"));
        columns = new ColumnLayout(tab.getComposite(), 2);
        left = new SimpleContainer(columns.getComposite());
        left.addLabelPair(i18n.tr("Zweck/Notiz/Art enth\u00e4lt"), this.getText());
        left.addLabelPair(i18n.tr("Mindest-Betrag"), this.getMindestBetrag());
        left.addLabelPair(i18n.tr("H\u00f6chst-Betrag"), this.getHoechstBetrag());
        right = new SimpleContainer(columns.getComposite());
        right.addLabelPair(i18n.tr("IBAN oder Kontonummer enth\u00e4lt"), (Input)this.getGegenkontoNummer());
        right.addLabelPair(i18n.tr("BIC oder BLZ enth\u00e4lt"), this.getGegenkontoBLZ());
        right.addLabelPair(i18n.tr("Name des Kontoinhabers enth\u00e4lt"), this.getGegenkontoName());
        tab = (Integer)cache.get("tab");
        if (tab != null) {
            folder.setSelection(((Integer)tab).intValue());
        }
        folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cache.put("tab", folder.getSelectionIndex());
            }
        });
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Exportieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugList.this.handlePrint();
            }
        }, null, false, "document-save.png");
        buttons.addButton(i18n.tr("Ums\u00e4tze abrufen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Object ctx = null;
                try {
                    ctx = KontoauszugList.this.getKontoAuswahl().getValue();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to get current konto", (Throwable)re);
                }
                new KontoFetchUmsaetze().handleAction(ctx);
            }
        }, null, false, "mail-send-receive.png");
        buttons.addButton(i18n.tr("Filter zur\u00fccksetzen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugList.this.handleReset();
            }
        }, null, false, "edit-undo.png");
        buttons.addButton(i18n.tr("&Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugList.this.handleReload(true);
            }
        }, null, true, "view-refresh.png");
        buttons.paint(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                KontoauszugList.this.disposed = true;
            }
        });
        this.reload();
        super.paint(parent);
        this.restoreState();
    }

    private SearchInput getSearch() throws RemoteException {
        if (this.search != null) {
            return this.search;
        }
        this.search = new SearchInput();
        return this.search;
    }

    private CheckboxInput getRegex() throws RemoteException {
        if (this.regex != null) {
            return this.regex;
        }
        Boolean b = (Boolean)cache.get("kontoauszug.list.regex");
        this.regex = new CheckboxInput(b != null && b != false);
        this.regex.setName(i18n.tr("Suchbegriff ist ein regul\u00e4rer Ausdruck"));
        this.regex.addListener(this.listener);
        return this.regex;
    }

    public KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(null, KontoFilter.ALL);
        this.kontoAuswahl.setSupportGroups(true);
        this.kontoAuswahl.setRememberSelection("auswertungen.kontoauszug");
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoAuswahl.addListener(this.listener);
        return this.kontoAuswahl;
    }

    public CheckboxInput getUnChecked() {
        if (this.unchecked != null) {
            return this.unchecked;
        }
        this.unchecked = new CheckboxInput(settings.getBoolean("kontoauszug.list.unchecked", false));
        this.unchecked.addListener(this.listener);
        return this.unchecked;
    }

    public Input getStart() {
        if (this.start != null) {
            return this.start;
        }
        this.start = new DateFromInput(null, "umsatzlist.filter.from");
        this.start.setName(i18n.tr("Von"));
        this.start.setComment(null);
        return this.start;
    }

    public Input getEnd() {
        if (this.end != null) {
            return this.end;
        }
        this.end = new DateToInput(null, "umsatzlist.filter.to");
        this.end.setName(i18n.tr("bis"));
        this.end.setComment(null);
        return this.end;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getStart(), this.getEnd(), Range.Category.AUSWERTUNG, "umsatzlist.filter.range");
        this.range.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (KontoauszugList.this.range.getValue() != null && KontoauszugList.this.range.hasChanged()) {
                    KontoauszugList.this.handleReload(true);
                }
            }
        });
        return this.range;
    }

    public UmsatzTypInput getKategorie() throws RemoteException {
        if (this.kategorie != null) {
            return this.kategorie;
        }
        UmsatzTyp preset = (UmsatzTyp)cache.get("kontoauszug.list.kategorie");
        if (preset == null || preset.getID() == null && preset != UmsatzTypUtil.UNASSIGNED) {
            preset = null;
        }
        this.kategorie = new UmsatzTypInput(preset, 2, true);
        this.kategorie.setPleaseChoose(i18n.tr("<Alle Kategorien>"));
        this.kategorie.setComment("");
        this.kategorie.addListener(this.listener);
        this.kategorie.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    KontoauszugList.this.getSubKategorien().setEnabled(KontoauszugList.this.kategorie.getValue() != null);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to update checkbox", (Throwable)e);
                }
            }
        });
        return this.kategorie;
    }

    public CheckboxInput getSubKategorien() throws RemoteException {
        if (this.subKategorien != null) {
            return this.subKategorien;
        }
        Boolean b = (Boolean)cache.get("kontoauszug.list.subkategorien");
        this.subKategorien = new CheckboxInput(b != null && b != false);
        this.subKategorien.addListener(this.listener);
        this.subKategorien.setEnabled(this.getKategorie().getValue() != null);
        return this.subKategorien;
    }

    public DialogInput getGegenkontoNummer() throws RemoteException {
        if (this.gegenkontoNummer != null) {
            return this.gegenkontoNummer;
        }
        AdresseAuswahlDialog d = new AdresseAuswahlDialog(0);
        d.addCloseListener(new AddressListener());
        this.gegenkontoNummer = new DialogInput((String)cache.get("kontoauszug.list.gegenkonto.nummer"), (AbstractDialog)d);
        this.gegenkontoNummer.setValidChars(HBCIProperties.HBCI_IBAN_VALIDCHARS);
        this.gegenkontoNummer.addListener(this.listener);
        return this.gegenkontoNummer;
    }

    public Input getGegenkontoBLZ() throws RemoteException {
        if (this.gegenkontoBLZ != null) {
            return this.gegenkontoBLZ;
        }
        this.gegenkontoBLZ = new BLZInput((String)cache.get("kontoauszug.list.gegenkonto.blz"));
        this.gegenkontoBLZ.setValidChars(HBCIProperties.HBCI_IBAN_VALIDCHARS);
        this.gegenkontoBLZ.setComment(null);
        this.gegenkontoBLZ.addListener(this.listener);
        return this.gegenkontoBLZ;
    }

    public Input getGegenkontoName() throws RemoteException {
        if (this.gegenkontoName != null) {
            return this.gegenkontoName;
        }
        this.gegenkontoName = new TextInput((String)cache.get("kontoauszug.list.gegenkonto.name"), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
        this.gegenkontoName.setValidChars(HBCIProperties.HBCI_DTAUS_VALIDCHARS);
        this.gegenkontoName.addListener(this.listener);
        return this.gegenkontoName;
    }

    public Input getText() throws RemoteException {
        if (this.text != null) {
            return this.text;
        }
        this.text = new TextInput((String)cache.get("kontoauszug.list.text"), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
        this.text.addListener(this.listener);
        return this.text;
    }

    public Input getMindestBetrag() throws RemoteException {
        if (this.betragFrom != null) {
            return this.betragFrom;
        }
        this.betragFrom = new DecimalInput((Number)((Double)cache.get("kontoauszug.list.betrag.from")), HBCI.DECIMALFORMAT);
        this.betragFrom.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        this.betragFrom.addListener(this.listener);
        this.betragFrom.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Input i;
                    Double value;
                    if (event.type == 16 && ((value = (Double)(i = KontoauszugList.this.getHoechstBetrag()).getValue()) == null || value.isNaN())) {
                        i.setValue(KontoauszugList.this.betragFrom.getValue());
                        ((Text)i.getControl()).selectAll();
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while auto applying max value", (Throwable)e);
                }
            }
        });
        return this.betragFrom;
    }

    public Input getHoechstBetrag() throws RemoteException {
        if (this.betragTo != null) {
            return this.betragTo;
        }
        this.betragTo = new DecimalInput((Number)((Double)cache.get("kontoauszug.list.betrag.to")), HBCI.DECIMALFORMAT);
        this.betragTo.setComment(HBCIProperties.CURRENCY_DEFAULT_DE);
        this.betragTo.addListener(this.listener);
        return this.betragTo;
    }

    private synchronized List<Umsatz> getUmsaetze() throws RemoteException {
        Object o = this.getKontoAuswahl().getValue();
        java.util.Date start = (java.util.Date)this.getStart().getValue();
        java.util.Date end = (java.util.Date)this.getEnd().getValue();
        String gkName = (String)this.getGegenkontoName().getValue();
        String gkBLZ = (String)this.getGegenkontoBLZ().getValue();
        String gkNummer = this.getGegenkontoNummer().getText();
        Double min = (Double)this.getMindestBetrag().getValue();
        Double max = (Double)this.getHoechstBetrag().getValue();
        String zk = (String)this.getText().getValue();
        String search = (String)this.getSearch().getValue();
        UmsatzTyp typ = (UmsatzTyp)this.getKategorie().getValue();
        boolean unchecked = (Boolean)this.getUnChecked().getValue();
        boolean subKategorien = (Boolean)this.getSubKategorien().getValue();
        boolean regex = (Boolean)this.getRegex().getValue();
        cache.put("kontoauszug.list.gegenkonto.nummer", gkNummer);
        cache.put("kontoauszug.list.gegenkonto.blz", gkBLZ);
        cache.put("kontoauszug.list.gegenkonto.name", gkName);
        cache.put("kontoauszug.list.kategorie", typ);
        cache.put("kontoauszug.list.text", zk);
        cache.put("kontoauszug.list.betrag.from", min);
        cache.put("kontoauszug.list.betrag.to", max);
        cache.put("kontoauszug.list.subkategorien", subKategorien);
        cache.put("kontoauszug.list.regex", regex);
        cache.put("kontoauszug.list.search", search);
        settings.setAttribute("kontoauszug.list.unchecked", unchecked);
        DBIterator umsaetze = UmsatzUtil.getUmsaetzeBackwards();
        this.filterCount = 0;
        if (start != null) {
            umsaetze.addFilter("datum >= ?", new Object[]{new Date(DateUtil.startOfDay((java.util.Date)start).getTime())});
        }
        if (end != null) {
            umsaetze.addFilter("datum <= ?", new Object[]{new Date(DateUtil.endOfDay((java.util.Date)end).getTime())});
        }
        if (gkBLZ != null && gkBLZ.length() > 0) {
            umsaetze.addFilter("LOWER(empfaenger_blz) like ?", new Object[]{"%" + gkBLZ.toLowerCase() + "%"});
            ++this.filterCount;
        }
        if (gkNummer != null && gkNummer.length() > 0) {
            umsaetze.addFilter("LOWER(empfaenger_konto) like ?", new Object[]{"%" + gkNummer.toLowerCase() + "%"});
            ++this.filterCount;
        }
        if (gkName != null && gkName.length() > 0) {
            umsaetze.addFilter("LOWER(empfaenger_name) like ?", new Object[]{"%" + gkName.toLowerCase() + "%"});
            ++this.filterCount;
        }
        if (o != null && o instanceof Konto) {
            umsaetze.addFilter("konto_id = " + ((Konto)o).getID());
            ++this.filterCount;
        } else if (o != null && o instanceof String) {
            umsaetze.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{(String)o});
            ++this.filterCount;
        }
        if (min != null && !Double.isNaN(min)) {
            umsaetze.addFilter("betrag >= ?", new Object[]{min});
            ++this.filterCount;
        }
        if (max != null && !Double.isNaN(max)) {
            umsaetze.addFilter("betrag <= ?", new Object[]{max});
            ++this.filterCount;
        }
        if (zk != null && zk.length() > 0) {
            ++this.filterCount;
            String zkStripped = zk = "%" + zk.toLowerCase() + "%";
            String q = "CONCAT(COALESCE(zweck,''),COALESCE(zweck2,''),COALESCE(zweck3,''))";
            if (syssettings.getBoolean("search.ignore.whitespace", true)) {
                q = "REPLACE(REPLACE(REPLACE(" + q + ",' ',''),'\n',''),'\r','')";
                zkStripped = StringUtils.deleteWhitespace((String)zk);
            }
            umsaetze.addFilter("(LOWER(" + q + ") LIKE ? OR LOWER(kommentar) like ? OR LOWER(art) like ?)", new Object[]{zkStripped, zk, zk});
        }
        if (unchecked) {
            ++this.filterCount;
            umsaetze.addFilter("(flags IS NULL OR flags = ? OR flags = ?)", new Object[]{0, 2});
        }
        if (search != null) {
            ++this.filterCount;
        }
        if (typ != null) {
            ++this.filterCount;
        }
        if (this.filterCount > 0) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Anzahl der Suchkriterien: {0}", Integer.toString(this.filterCount)), 2));
        }
        if (search != null) {
            this.searchTyp.setPattern(search);
            this.searchTyp.setRegex(regex);
        }
        boolean logged = false;
        LinkedList<Umsatz> result = new LinkedList<Umsatz>();
        while (umsaetze.hasNext()) {
            Umsatz u;
            block21: {
                u = (Umsatz)umsaetze.next();
                if (typ != null && !this.matches(typ, u, subKategorien)) continue;
                try {
                    if (search != null && !this.searchTyp.matches(u, true)) {
                        continue;
                    }
                }
                catch (PatternSyntaxException pe) {
                    if (logged) break block21;
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(pe.getLocalizedMessage(), 1));
                    logged = true;
                }
            }
            result.add(u);
        }
        return result;
    }

    private boolean matches(UmsatzTyp typ, Umsatz u, boolean children) throws RemoteException {
        UmsatzTyp t = u.getUmsatzTyp();
        if (t == null && typ != null && typ == UmsatzTypUtil.UNASSIGNED) {
            return true;
        }
        int i = 0;
        while (i < 100) {
            if (t == null) {
                return false;
            }
            if (t.equals((GenericObject)typ)) {
                return true;
            }
            if (!children) break;
            t = (UmsatzTyp)t.getParent();
            ++i;
        }
        return false;
    }

    private synchronized void handlePrint() {
        try {
            this.handleReload(true);
            List list = this.getItems();
            if (list == null || list.size() == 0) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Keine zu exportierenden Ums\u00e4tze"), 1));
                return;
            }
            Exporter.SESSION.put((Object)"filtered", (Object)(this.filterCount > 0 ? 1 : 0));
            Exporter.SESSION.put((Object)"pdf.start", this.getStart().getValue());
            Exporter.SESSION.put((Object)"pdf.end", this.getEnd().getValue());
            Umsatz[] u = list.toArray(new Umsatz[0]);
            new UmsatzExport().handleAction(u);
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getLocalizedMessage(), 1));
        }
        catch (RemoteException re) {
            Logger.error((String)"error while reloading table", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Exportieren der Ums\u00e4tze"), 1));
        }
    }

    private synchronized void handleReset() {
        try {
            Range range = (Range)this.getRange().getValue();
            this.getStart().setValue((Object)(range != null ? range.getStart() : null));
            this.getEnd().setValue((Object)(range != null ? range.getEnd() : null));
            this.getMindestBetrag().setValue((Object)Double.NaN);
            this.getHoechstBetrag().setValue((Object)Double.NaN);
            this.getKontoAuswahl().setValue(null);
            this.getKategorie().setValue(null);
            this.getSubKategorien().setValue((Object)Boolean.FALSE);
            this.getGegenkontoNummer().setText("");
            this.getGegenkontoBLZ().setValue(null);
            this.getGegenkontoName().setValue(null);
            this.getText().setValue(null);
            this.getSearch().setValue(null);
            this.getRegex().setValue((Object)Boolean.FALSE);
            this.getUnChecked().setValue((Object)Boolean.FALSE);
            this.changed = true;
            this.handleReload(true);
        }
        catch (Exception e) {
            Logger.error((String)"unable to reset filters", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Zur\u00fccksetzen der Filter"), 1));
        }
    }

    private synchronized void handleReload(boolean force) {
        if (this.disposed) {
            return;
        }
        if (!force && !this.hasChanged()) {
            return;
        }
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GUI.startSync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        KontoauszugList.this.reload();
                    }
                });
            }
        });
    }

    private void reload() {
        try {
            this.removeAll();
            List<Umsatz> list = this.getUmsaetze();
            for (Umsatz u : list) {
                this.addItem(u);
            }
            this.sort();
            this.restoreState();
        }
        catch (Exception e) {
            Logger.error((String)"error while reloading table", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Ums\u00e4tze"), 1));
        }
    }

    private boolean hasChanged() {
        try {
            boolean b = this.changed;
            this.changed = false;
            return InputCompat.valueHasChanged(b, new Input[]{this.getStart(), this.getEnd(), this.getUnChecked(), this.getSearch(), this.getRegex(), this.getKontoAuswahl(), this.getGegenkontoName(), this.getGegenkontoNummer(), this.getGegenkontoBLZ(), this.getMindestBetrag(), this.getHoechstBetrag(), this.getKategorie(), this.getSubKategorien(), this.getText()});
        }
        catch (Exception e) {
            Logger.error((String)"unable to check change status", (Throwable)e);
            return false;
        }
    }

    private class AddressListener
    implements Listener {
        private AddressListener() {
        }

        public void handleEvent(Event event) {
            if (event == null || event.data == null) {
                return;
            }
            Address address = (Address)event.data;
            try {
                KontoauszugList.this.getGegenkontoNummer().setText(address.getKontonummer());
                KontoauszugList.this.getGegenkontoBLZ().setValue((Object)address.getBlz());
                KontoauszugList.this.getGegenkontoName().setValue((Object)address.getName());
            }
            catch (RemoteException er) {
                Logger.error((String)"error while choosing gegenkonto", (Throwable)er);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler bei der Auswahl des Gegenkontos"), 1));
            }
        }
    }

    private class SearchInput
    extends ButtonInput {
        private Text text = null;

        private SearchInput() {
            this.setName(i18n.tr("Suchbegriff"));
            this.addButtonListener(new Listener(){

                public void handleEvent(Event event) {
                    Menu menu = new Menu((Decorations)GUI.getShell(), 8);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(i18n.tr("Suchbegriff als Umsatz-Kategorie speichern..."));
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            try {
                                String text = (String)((SearchInput)(this).SearchInput.this).KontoauszugList.this.search.getValue();
                                if (text == null || text.length() == 0) {
                                    return;
                                }
                                DBIterator existing = Settings.getDBService().createList(UmsatzTyp.class);
                                existing.addFilter("pattern = ?", new Object[]{text});
                                UmsatzTyp typ = null;
                                if (existing.size() > 0) {
                                    if (!Application.getCallback().askUser(i18n.tr("Eine Umsatz-Kategorie mit diesem Suchbegriff existiert bereits. \u00dcberschreiben?"))) {
                                        return;
                                    }
                                    typ = (UmsatzTyp)existing.next();
                                } else {
                                    UmsatzTypNewDialog d = new UmsatzTypNewDialog(0);
                                    typ = (UmsatzTyp)d.open();
                                }
                                typ.setPattern(text);
                                typ.setRegex((Boolean)((SearchInput)(this).SearchInput.this).KontoauszugList.this.regex.getValue());
                                typ.store();
                                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Umsatz-Kategorie gespeichert"), 0));
                            }
                            catch (ApplicationException ae) {
                                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                            }
                            catch (OperationCanceledException oce) {
                                Logger.info((String)"operation cancelled");
                                return;
                            }
                            catch (Exception ex) {
                                Logger.error((String)"unable to store umsatz filter", (Throwable)ex);
                                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern der Umsatz-Kategorie"));
                            }
                        }
                    });
                    new MenuItem(menu, 2);
                    try {
                        DBIterator i = Settings.getDBService().createList(UmsatzTyp.class);
                        i.addFilter("pattern is not null and pattern != ''");
                        while (i.hasNext()) {
                            UmsatzTyp ut = (UmsatzTyp)i.next();
                            String s = ut.getName();
                            final String p = ut.getPattern();
                            final boolean ir = ut.isRegex();
                            MenuItem mi = new MenuItem(menu, 8);
                            mi.setText(s);
                            mi.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    Logger.debug((String)("applying filter " + p));
                                    ((SearchInput)(this).SearchInput.this).KontoauszugList.this.regex.setValue((Object)ir);
                                    ((SearchInput)(this).SearchInput.this).KontoauszugList.this.search.setValue(p);
                                    ((SearchInput)(this).SearchInput.this).KontoauszugList.this.search.focus();
                                    KontoauszugList.this.handleReload(false);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        Logger.error((String)"unable to load umsatz filter", (Throwable)ex);
                        GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Laden der Umsatz-Kategorien"));
                    }
                    menu.setLocation(GUI.getDisplay().getCursorLocation());
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (GUI.getDisplay().readAndDispatch()) continue;
                        GUI.getDisplay().sleep();
                    }
                    menu.dispose();
                }
            });
        }

        public Control getClientControl(Composite parent) {
            if (this.text != null) {
                return this.text;
            }
            this.text = GUI.getStyleFactory().createText(parent);
            String s = (String)cache.get("kontoauszug.list.search");
            this.setValue(s);
            this.hasChanged();
            if (syssettings.getBoolean("usage.instantsearch", false)) {
                this.text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        ((SearchInput)SearchInput.this).KontoauszugList.this.listener.handleEvent(null);
                    }
                });
            }
            return this.text;
        }

        public Object getValue() {
            return this.text != null && !this.text.isDisposed() ? StringUtils.trimToNull((String)this.text.getText()) : null;
        }

        public void setValue(Object value) {
            if (this.text == null || this.text.isDisposed()) {
                return;
            }
            this.text.setText(value != null ? value.toString() : "");
        }
    }
}

