/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TableChangeListener;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureShortcut;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.KontoFetchKontoauszug;
import de.willuhn.jameica.hbci.gui.action.KontoauszugOpen;
import de.willuhn.jameica.hbci.gui.action.KontoauszugPdfSettings;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.InputCompat;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TableItem;

public class KontoauszugPdfList
extends TablePart {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = null;
    private KontoInput kontoAuswahl = null;
    private Input from = null;
    private Input to = null;
    private RangeInput range = null;
    private CheckboxInput unread = null;
    private CheckboxInput inclusiveFilter = null;
    private Listener listener = null;

    public KontoauszugPdfList() {
        super((Action)new KontoauszugOpen());
        this.addFeature((Feature)new FeatureShortcut());
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                KontoauszugPdfList.this.handleReload(event == null);
            }
        };
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    Kontoauszug k = (Kontoauszug)item.getData();
                    if (k.getGelesenAm() != null) {
                        item.setFont(Font.DEFAULT.getSWTFont());
                        item.setImage(0, SWTUtil.getImage((String)"emblem-default.png"));
                    } else {
                        item.setFont(Font.BOLD.getSWTFont());
                        item.setImage(0, null);
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"error while checking read-state of account statements", (Throwable)re);
                }
            }
        });
        DateFormatter df = new DateFormatter();
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Jahr"), "jahr");
        this.addColumn(i18n.tr("Nummer"), "nummer");
        this.addColumn(i18n.tr("Von"), "von", (Formatter)df);
        this.addColumn(i18n.tr("Bis"), "bis", (Formatter)df);
        this.addColumn(i18n.tr("Erstellt am"), "erstellungsdatum", (Formatter)df);
        this.addColumn(i18n.tr("Abgerufen am"), "ausgefuehrt_am", (Formatter)df);
        this.addColumn(i18n.tr("Quittiert am"), "quittiert_am", (Formatter)df);
        this.addColumn(i18n.tr("Notiz"), "kommentar", null, true);
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setRememberState(true);
        this.setMulti(true);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.KontoauszugPdfList());
        this.addChangeListener(new TableChangeListener(){

            public void itemChanged(Object object, String attribute, String newValue) throws ApplicationException {
                try {
                    Kontoauszug u = (Kontoauszug)object;
                    BeanUtil.set((Object)u, (String)attribute, (Object)newValue);
                    u.store();
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply changes", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()));
                }
            }
        });
        this.mc = new TransferMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(cols.getComposite());
        left.addInput((Input)this.getKontoAuswahl());
        left.addInput((Input)this.getInclusiveFilter());
        left.addInput((Input)this.getUnread());
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput((Input)this.getRange());
        MultiInput range = new MultiInput(new Input[]{this.getFrom(), this.getTo()});
        right.addInput((Input)range);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Kontoausz\u00fcge abrufen..."), (Action)new KontoAction(new KontoFetchKontoauszug()), null, false, "mail-send-receive.png");
        buttons.addButton(i18n.tr("Einstellungen"), (Action)new KontoAction(new KontoauszugPdfSettings()), null, false, "document-properties.png");
        buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                KontoauszugPdfList.this.handleReload(true);
            }
        }, null, true, "view-refresh.png");
        buttons.paint(parent);
        this.handleReload(true);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(KontoauszugPdfList.this.mc);
            }
        });
        super.paint(parent);
    }

    private KontoInput getKontoAuswahl() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(null, KontoFilter.ONLINE);
        this.kontoAuswahl.setSupportGroups(true);
        this.kontoAuswahl.setRememberSelection("kontoauszuege.filter.konto");
        this.kontoAuswahl.setComment(null);
        this.kontoAuswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoAuswahl.addListener(this.listener);
        return this.kontoAuswahl;
    }

    private synchronized Input getFrom() {
        if (this.from != null) {
            return this.from;
        }
        this.from = new DateFromInput(null, "kontoauszuege.filter.from");
        this.from.setName(i18n.tr("Von"));
        this.from.setComment(null);
        this.from.addListener(this.listener);
        return this.from;
    }

    public synchronized Input getTo() {
        if (this.to != null) {
            return this.to;
        }
        this.to = new DateToInput(null, "kontoauszuege.filter.to");
        this.to.setName(i18n.tr("bis"));
        this.to.setComment(null);
        this.to.addListener(this.listener);
        return this.to;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getFrom(), this.getTo(), Range.Category.AUSWERTUNG, "kontoauszuege.filter.range");
        this.range.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (KontoauszugPdfList.this.range.getValue() != null && KontoauszugPdfList.this.range.hasChanged()) {
                    KontoauszugPdfList.this.handleReload(true);
                }
            }
        });
        return this.range;
    }

    public CheckboxInput getUnread() {
        if (this.unread != null) {
            return this.unread;
        }
        this.unread = new CheckboxInput(settings.getBoolean("kontoauszuege.filter.unread", false));
        this.unread.setName(i18n.tr("Nur ungelesene Kontoausz\u00fcge anzeigen"));
        this.unread.addListener(this.listener);
        return this.unread;
    }

    public CheckboxInput getInclusiveFilter() {
        if (this.inclusiveFilter != null) {
            return this.inclusiveFilter;
        }
        this.inclusiveFilter = new CheckboxInput(settings.getBoolean("kontoauszuege.filter.inclusivefilter", false));
        this.inclusiveFilter.setName(i18n.tr("Auch nur teilweise im Zeitraum liegende Kontoausz\u00fcge anzeigen"));
        this.inclusiveFilter.addListener(this.listener);
        this.inclusiveFilter.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("kontoauszuege.filter.inclusivefilter", ((Boolean)KontoauszugPdfList.this.getInclusiveFilter().getValue()).booleanValue());
            }
        });
        return this.inclusiveFilter;
    }

    private synchronized void handleReload(boolean force) {
        try {
            final Object konto = this.getKontoAuswahl().getValue();
            final Date dfrom = (Date)this.getFrom().getValue();
            final Date dto = (Date)this.getTo().getValue();
            final Boolean unread = (Boolean)this.getUnread().getValue();
            final Boolean inclusiveFilter = (Boolean)this.getInclusiveFilter().getValue();
            if (!force) {
                if (!this.hasChanged()) {
                    return;
                }
                if (dfrom != null && dto != null && dfrom.after(dto)) {
                    GUI.getView().setErrorText(i18n.tr("End-Datum muss sich nach dem Start-Datum befinden"));
                    return;
                }
            }
            GUI.startSync((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        KontoauszugPdfList.this.removeAll();
                        GenericIterator<Kontoauszug> items = KontoauszugPdfUtil.getList(konto, dfrom, dto, unread != null ? unread : false, inclusiveFilter != null ? inclusiveFilter : false);
                        if (items == null) {
                            return;
                        }
                        items.begin();
                        while (items.hasNext()) {
                            KontoauszugPdfList.this.addItem(items.next());
                        }
                        KontoauszugPdfList.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while reloading table", (Throwable)e);
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Tabelle"), 1));
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.error((String)"error while reloading data", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der Tabelle"), 1));
        }
    }

    protected boolean hasChanged() {
        return InputCompat.valueHasChanged(new Input[]{this.kontoAuswahl, this.from, this.to, this.unread, this.inclusiveFilter});
    }

    public void handleSettings() throws ApplicationException {
        new KontoAction(new KontoauszugPdfSettings()).handleAction(null);
    }

    private class KontoAction
    implements Action {
        private Action redirect = null;

        private KontoAction(Action redirect) {
            this.redirect = redirect;
        }

        public void handleAction(Object context) throws ApplicationException {
            Konto k = null;
            try {
                Object o = KontoauszugPdfList.this.getKontoAuswahl().getValue();
                if (o != null && o instanceof Konto) {
                    k = (Konto)o;
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to determine account", (Throwable)e);
            }
            this.redirect.handleAction(k);
        }
    }

    public class TransferMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(final Message message) throws Exception {
            if (message == null) {
                return;
            }
            final GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (!(o instanceof Kontoauszug)) {
                return;
            }
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message instanceof ObjectChangedMessage) {
                            KontoauszugPdfList.this.updateItem(o, o);
                        } else if (message instanceof ImportMessage) {
                            KontoauszugPdfList.this.addItem(o);
                            KontoauszugPdfList.this.sort();
                            KontoauszugPdfList.this.handleReload(true);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update item", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

