/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Nachricht;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.TableItem;

public class NachrichtList
extends TablePart
implements Part {
    private I18N i18n = null;

    public NachrichtList(Action action) throws RemoteException {
        this((GenericIterator)NachrichtList.init(), action);
    }

    public NachrichtList(GenericIterator list, Action action) {
        super(list, action);
        this.setMulti(true);
        this.i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                Nachricht n = (Nachricht)item.getData();
                try {
                    item.setFont(n.isGelesen() ? Font.DEFAULT.getSWTFont() : Font.BOLD.getSWTFont());
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while checking for message read status", (Throwable)e);
                }
            }
        });
        this.addColumn(this.i18n.tr("Datum"), "datum", (Formatter)new DateFormatter(HBCI.DATEFORMAT));
        this.addColumn(this.i18n.tr("Bank"), "blz", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                String blz = o.toString();
                return NachrichtList.this.i18n.tr("{0} [BLZ: {1}]", new String[]{HBCIProperties.getNameForBank(blz), blz});
            }
        });
        this.addColumn(this.i18n.tr("Nachricht"), "nachricht", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                String s = (String)o;
                if (s.indexOf(10) != -1) {
                    return s;
                }
                s = s.replaceAll("( {1,})", " ");
                s = s.replaceAll("(.{77})", "$1\n");
                return s;
            }
        });
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.NachrichtList());
    }

    private static DBIterator init() throws RemoteException {
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(Nachricht.class);
        list.setOrder("ORDER BY gelesen, blz, " + service.getSQLTimestamp("datum") + " desc");
        return list;
    }
}

