/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportPropertyList
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final String PREFIX_BPD = "BPD";
    private static final String PREFIX_UPD = "UPD";
    private HBCIPassport passport = null;
    private List<Value> list = new ArrayList<Value>();
    private PropertyTable table = null;
    private TextInput search = null;

    public PassportPropertyList(HBCIPassport passport) {
        this.passport = passport;
    }

    public void paint(Composite parent) throws RemoteException {
        SimpleContainer container = new SimpleContainer(parent);
        this.list.addAll(PassportPropertyList.init(PREFIX_BPD, this.passport.getBPD()));
        this.list.addAll(PassportPropertyList.init(PREFIX_UPD, this.passport.getUPD()));
        this.search = new TextInput(null);
        this.search.setName(i18n.tr("Suche"));
        container.addInput((Input)this.search);
        this.search.getControl().addKeyListener((KeyListener)new DelayedAdapter());
        this.table = new PropertyTable();
        this.table.paint(parent);
    }

    public synchronized void clearBPD() {
        ArrayList<Value> newList = new ArrayList<Value>();
        for (Value value : this.list) {
            if (PREFIX_BPD.equals(value.prefix)) continue;
            newList.add(value);
        }
        this.list = newList;
        this.reload();
    }

    private static List<Value> init(String prefix, Properties props) {
        ArrayList<Value> l = new ArrayList<Value>();
        if (props == null) {
            return l;
        }
        Object[] keys = props.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            l.add(new Value(prefix, (String)key, props.getProperty((String)key)));
            ++n2;
        }
        return l;
    }

    private void reload() {
        try {
            String text = (String)this.search.getValue();
            this.table.removeAll();
            String lower = null;
            for (Value v : this.list) {
                if (text == null || text.length() == 0) {
                    this.table.addItem(v);
                    continue;
                }
                String prefix = v.prefix;
                String name = v.name;
                String value = v.value;
                if (name == null) {
                    name = "";
                }
                if (value == null) {
                    value = "";
                }
                if (lower == null) {
                    lower = text.toLowerCase();
                }
                if (name.toLowerCase().indexOf(lower) == -1 && value.toLowerCase().indexOf(lower) == -1 && prefix.toLowerCase().indexOf(lower) == -1) continue;
                this.table.addItem(v);
            }
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"unable to perform search", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ausf\u00fchren der Suche: {0}", e.getMessage()), 1));
        }
    }

    private class DelayedAdapter
    extends KeyAdapter {
        private Listener forward = new DelayedListener(new Listener(){

            public void handleEvent(Event event) {
                PassportPropertyList.this.reload();
            }
        });

        private DelayedAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }

    private class PropertyTable
    extends TablePart {
        private PropertyTable() {
            super(PassportPropertyList.this.list, null);
            this.setRememberColWidths(true);
            this.setSummary(true);
            this.addColumn(i18n.tr("BPD/UPD"), "prefix");
            this.addColumn(i18n.tr("Parameter"), "name");
            this.addColumn(i18n.tr("Wert"), "value");
        }
    }

    private static class Value
    implements GenericObject {
        private String prefix = null;
        private String name = null;
        private String value = null;

        private Value(String prefix, String name, String value) {
            this.prefix = prefix;
            this.name = name;
            this.value = value;
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof Value)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            if ("name".equals(name)) {
                return this.name;
            }
            if ("prefix".equals(name)) {
                return this.prefix;
            }
            return this.value;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"prefix", "name", "value"};
        }

        public String getID() throws RemoteException {
            return String.valueOf(this.prefix) + this.name + this.value;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }
}

