/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.PassportRegistry;
import de.willuhn.jameica.hbci.gui.action.PassportDetail;
import de.willuhn.jameica.hbci.passport.Configuration;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.TreeItem;

public class PassportTree
extends TreePart {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public PassportTree() throws RemoteException {
        super(PassportTree.init(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || context instanceof Object[]) {
                    return;
                }
                PassportDetail a = new PassportDetail();
                if (context instanceof PassportObject) {
                    a.handleAction(((PassportObject)context).passport);
                } else if (context instanceof ConfigObject) {
                    a.handleAction(((ConfigObject)context).config);
                }
            }
        });
        this.addColumn(i18n.tr("Bezeichnung"), "name");
        this.setFormatter(new TreeFormatter(){

            public void format(TreeItem item) {
                Object data = item.getData();
                if (data instanceof ConfigObject) {
                    ConfigObject o = (ConfigObject)data;
                    Passport p = o.passport;
                    String icon = "system-users.png";
                    if (p instanceof de.willuhn.jameica.hbci.passports.pintan.rmi.Passport) {
                        icon = "hbci-pintan.png";
                    } else if (p instanceof de.willuhn.jameica.hbci.passports.rdh.rmi.Passport) {
                        icon = "dialog-password.png";
                    } else if (p instanceof de.willuhn.jameica.hbci.passports.ddv.rmi.Passport) {
                        icon = "gcr-smart-card.png";
                    }
                    item.setImage(SWTUtil.getImage((String)icon));
                }
            }
        });
        this.setMulti(false);
        ContextMenu menu = new ContextMenu();
        menu.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("\u00d6ffnen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof ConfigObject)) {
                    return;
                }
                new PassportDetail().handleAction(((ConfigObject)context).config);
            }
        }, "document-open.png"){

            public boolean isEnabledFor(Object o) {
                return o instanceof ConfigObject && super.isEnabledFor(o);
            }
        });
        menu.addItem(new ContextMenuItem(i18n.tr("Neuer Bank-Zugang..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Object o = PassportTree.this.getSelection();
                Passport p = o instanceof PassportObject ? ((PassportObject)o).passport : null;
                new PassportDetail().handleAction(p);
            }
        }, "list-add.png"));
        menu.addItem(ContextMenuItem.SEPARATOR);
        menu.addItem((ContextMenuItem)new CheckedSingleContextMenuItem(i18n.tr("L\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof ConfigObject)) {
                    return;
                }
                Configuration config = ((ConfigObject)context).config;
                if (config == null) {
                    return;
                }
                try {
                    if (!Application.getCallback().askUser(i18n.tr("Wollen Sie diesen Bank-Zugang wirklich l\u00f6schen?\nDie Konten, Auftr\u00e4ge und Ums\u00e4tze bleiben erhalten."))) {
                        return;
                    }
                }
                catch (OperationCanceledException oce) {
                    Logger.info((String)"operation cancelled");
                    return;
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to delete config", (Throwable)e);
                    throw new ApplicationException(i18n.tr("L\u00f6schen fehlgeschlagen: {0}", e.getMessage()));
                }
                config.delete();
                GUI.startView((AbstractView)GUI.getCurrentView(), null);
            }
        }, "user-trash-full.png"){

            public boolean isEnabledFor(Object o) {
                return o instanceof ConfigObject && super.isEnabledFor(o);
            }
        });
        this.setContextMenu(menu);
    }

    public Passport getPassport() {
        Object o = this.getSelection();
        if (o instanceof PassportObject) {
            return ((PassportObject)o).passport;
        }
        if (o instanceof ConfigObject) {
            return ((ConfigObject)o).passport;
        }
        return null;
    }

    private static GenericIterator init() throws RemoteException {
        try {
            Passport[] passports = PassportRegistry.getPassports();
            ArrayList<PassportObject> list = new ArrayList<PassportObject>();
            Passport[] passportArray = passports;
            int n = passports.length;
            int n2 = 0;
            while (n2 < n) {
                Passport p = passportArray[n2];
                list.add(new PassportObject(p));
                ++n2;
            }
            return PseudoIterator.fromArray((GenericObject[])((GenericObject[])list.toArray(new PassportObject[0])));
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to create passport tree", e);
        }
    }

    private static class ConfigObject
    implements GenericObject {
        private Passport passport = null;
        private Configuration config = null;

        private ConfigObject(Passport passport, Configuration config) {
            this.passport = passport;
            this.config = config;
        }

        public boolean equals(GenericObject o) throws RemoteException {
            if (o == null || !(o instanceof PassportObject)) {
                return false;
            }
            ConfigObject other = (ConfigObject)o;
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            if ("name".equals(name)) {
                return this.config.getDescription();
            }
            return BeanUtil.get((Object)this.config, (String)name);
        }

        public String[] getAttributeNames() throws RemoteException {
            return null;
        }

        public String getID() throws RemoteException {
            if (this.config instanceof GenericObject) {
                return ((GenericObject)this.config).getID();
            }
            return String.valueOf(this.config.getClass().getName()) + ":" + this.config.getDescription();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "description";
        }
    }

    private static class PassportObject
    implements GenericObjectNode {
        private Passport passport = null;
        private GenericIterator children = null;

        private PassportObject(Passport passport) {
            this.passport = passport;
        }

        public boolean equals(GenericObject o) throws RemoteException {
            if (o == null || !(o instanceof PassportObject)) {
                return false;
            }
            PassportObject other = (PassportObject)o;
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            return BeanUtil.get((Object)this.passport, (String)name);
        }

        public String[] getAttributeNames() throws RemoteException {
            return null;
        }

        public String getID() throws RemoteException {
            return this.passport.getClass().getName();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "description";
        }

        public GenericIterator getChildren() throws RemoteException {
            if (this.children != null) {
                return this.children;
            }
            List<? extends Configuration> configs = this.passport.getConfigurations();
            ArrayList<ConfigObject> list = new ArrayList<ConfigObject>();
            for (Configuration configuration : configs) {
                list.add(new ConfigObject(this.passport, configuration));
            }
            this.children = PseudoIterator.fromArray((GenericObject[])list.toArray(new ConfigObject[0]));
            return this.children;
        }

        public GenericObjectNode getParent() throws RemoteException {
            return null;
        }

        public GenericIterator getPath() throws RemoteException {
            return null;
        }

        public GenericIterator getPossibleParents() throws RemoteException {
            return null;
        }

        public boolean hasChild(GenericObjectNode children) throws RemoteException {
            return this.getChildren().contains((GenericObject)children) != null;
        }
    }
}

