/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.parts.AbstractFromToList;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Protokoll;
import de.willuhn.jameica.util.DateUtil;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.TableItem;

public class ProtokollList
extends AbstractFromToList {
    private KontoInput kontoAuswahl = null;
    private Konto konto = null;

    public ProtokollList(Konto konto, Action action) {
        super(action);
        this.konto = konto;
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Protokoll p = (Protokoll)item.getData();
                if (p == null) {
                    return;
                }
                try {
                    int type = p.getTyp();
                    switch (type) {
                        case 2: {
                            item.setForeground(Color.ERROR.getSWTColor());
                            break;
                        }
                        case 1: {
                            item.setForeground(Color.SUCCESS.getSWTColor());
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        this.addColumn(i18n.tr("Datum"), "datum", (Formatter)new DateFormatter(HBCI.LONGDATEFORMAT));
        this.addColumn(i18n.tr("Kommentar"), "kommentar");
    }

    @Override
    public KontoInput getKonto() throws RemoteException {
        if (this.kontoAuswahl != null) {
            return this.kontoAuswahl;
        }
        this.kontoAuswahl = new KontoInput(this.konto, KontoFilter.ALL);
        this.kontoAuswahl.setEnabled(false);
        this.kontoAuswahl.setComment(null);
        return this.kontoAuswahl;
    }

    @Override
    protected DBIterator getList(Object konto, Date from, Date to, String text) throws RemoteException {
        if (konto == null || !(konto instanceof Konto)) {
            return null;
        }
        DBIterator list = ((Konto)konto).getProtokolle();
        if (from != null) {
            list.addFilter("datum >= ?", new Object[]{new java.sql.Date(DateUtil.startOfDay((Date)from).getTime())});
        }
        if (to != null) {
            list.addFilter("datum <= ?", new Object[]{new java.sql.Date(DateUtil.endOfDay((Date)to).getTime())});
        }
        if (text != null && text.length() > 0) {
            list.addFilter("LOWER(kommentar) like ?", new Object[]{"%" + text.toLowerCase() + "%"});
        }
        return list;
    }
}

