/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.CustomRangeEdit;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class RangeList
extends TablePart {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Range.Category category = null;

    public RangeList(final Range.Category category) {
        super(new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (!(context instanceof Range.CustomRange)) {
                    return;
                }
                new CustomRangeEdit(category).handleAction(context);
            }
        });
        this.category = category;
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Object data = item.getData();
                if (data instanceof Range.CustomRange) {
                    item.setFont(Font.BOLD.getSWTFont());
                }
            }
        });
        this.setCheckable(true);
        this.setMulti(false);
        this.setRememberColWidths(true);
        this.setRememberState(true);
        this.setRememberOrder(false);
        this.removeFeature(FeatureSummary.class);
        this.addColumn(i18n.tr("Bezeichnung"), null);
        ContextMenu ctx = new ContextMenu();
        ctx.addItem(new ContextMenuItem(i18n.tr("Neuer Zeitraum..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new CustomRangeEdit(category).handleAction(Range.CustomRange.create());
            }
        }, "document-new.png"));
        ctx.addItem((ContextMenuItem)new CustomRangeContextMenuItem(i18n.tr("Bearbeiten..."), new CustomRangeEdit(category), "document-open.png"));
        ctx.addItem((ContextMenuItem)new CustomRangeContextMenuItem(i18n.tr("L\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Range.deleteCustomRange(category, (Range.CustomRange)context);
                RangeList.this.reload();
            }
        }, "user-trash-full.png"));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem(new ContextMenuItem(i18n.tr("Zur\u00fccksetzen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Range.resetActiveRanges(category);
                List<Range> active = Range.getActiveRanges(category);
                for (Range r : Range.getAllRanges(category)) {
                    RangeList.this.setChecked(r, active.contains(r));
                }
            }
        }, "edit-undo.png"));
        this.setContextMenu(ctx);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        super.paint(parent);
        this.reload();
    }

    private void reload() {
        try {
            this.removeAll();
            List<Range> active = Range.getActiveRanges(this.category);
            for (Range r : Range.getAllRanges(this.category)) {
                this.addItem(r, active.contains(r));
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load ranges", (Throwable)e);
        }
    }

    private class CustomRangeContextMenuItem
    extends CheckedSingleContextMenuItem {
        public CustomRangeContextMenuItem(String name, Action action, String icon) {
            super(name, action, icon);
        }

        public boolean isEnabledFor(Object o) {
            if (!super.isEnabledFor(o)) {
                return false;
            }
            return o instanceof Range.CustomRange;
        }
    }
}

