/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DateInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.ScaleInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.action.KontoLimitsConfigure;
import de.willuhn.jameica.hbci.gui.chart.AbstractChartDataSaldo;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoForecast;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoLimit;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoSumme;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoSummeForecast;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoTrend;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoTrendForecast;
import de.willuhn.jameica.hbci.gui.chart.LineChart;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.gui.input.UmsatzDaysInput;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceProvider;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ColorGenerator;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;

public class SaldoChart
implements Part {
    private static final String FORCE = "FORCE";
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private Konto konto = null;
    private boolean tiny = false;
    private KontoInput kontoauswahl = null;
    private UmsatzDaysInput rangeTiny = null;
    private DateInput start = null;
    private DateInput end = null;
    private RangeInput range = null;
    private CheckboxInput onlyActive = null;
    private Listener reloadListener = new ReloadListener();
    private LineChart chart = null;

    public SaldoChart() {
        this(null);
    }

    public SaldoChart(Konto konto) {
        this.konto = konto;
    }

    public void setTinyView(boolean b) {
        this.tiny = b;
    }

    private SelectInput getKontoAuswahl() throws RemoteException {
        if (this.kontoauswahl != null) {
            return this.kontoauswahl;
        }
        this.kontoauswahl = new KontoInput(null, KontoFilter.ALL);
        this.kontoauswahl.setSupportGroups(true);
        this.kontoauswahl.setRememberSelection("auswertungen.saldochart");
        this.kontoauswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoauswahl.setComment(null);
        this.kontoauswahl.addListener(this.reloadListener);
        return this.kontoauswahl;
    }

    private ScaleInput getRangeTiny() throws RemoteException {
        if (this.rangeTiny != null) {
            return this.rangeTiny;
        }
        this.rangeTiny = new UmsatzDaysInput();
        this.rangeTiny.setRememberSelection("days.saldochart");
        this.rangeTiny.addListener((Listener)new DelayedListener(300, this.reloadListener));
        return this.rangeTiny;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        this.range = new RangeInput(this.getStart(), this.getEnd(), Range.Category.AUSWERTUNG, "auswertungen.saldochart.filter.range");
        this.range.addListener(this.reloadListener);
        return this.range;
    }

    public Input getStart() {
        if (this.start != null) {
            return this.start;
        }
        this.start = new DateFromInput(null, "auswertungen.saldochart.filter.from");
        this.start.setName(i18n.tr("Von"));
        this.start.setComment(null);
        this.start.addListener((Listener)new DelayedListener(300, this.reloadListener));
        return this.start;
    }

    public Input getEnd() {
        if (this.end != null) {
            return this.end;
        }
        this.end = new DateToInput(null, "auswertungen.saldochart.filter.to");
        this.end.setName(i18n.tr("bis"));
        this.end.setComment(null);
        this.end.addListener((Listener)new DelayedListener(300, this.reloadListener));
        return this.end;
    }

    public CheckboxInput getActiveOnly() {
        if (this.onlyActive != null) {
            return this.onlyActive;
        }
        this.onlyActive = new CheckboxInput(settings.getBoolean("auswertungen.saldochart.filter.active", false));
        this.onlyActive.setName(i18n.tr("Nur aktive Konten"));
        this.onlyActive.addListener(this.reloadListener);
        this.onlyActive.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("auswertungen.saldochart.filter.active", ((Boolean)SaldoChart.this.onlyActive.getValue()).booleanValue());
            }
        });
        return this.onlyActive;
    }

    public void paint(Composite parent) throws RemoteException {
        try {
            if (this.konto == null) {
                if (this.tiny) {
                    ColumnLayout layout = new ColumnLayout(parent, 2);
                    SimpleContainer left = new SimpleContainer(layout.getComposite());
                    left.addInput((Input)this.getKontoAuswahl());
                    SimpleContainer right = new SimpleContainer(layout.getComposite());
                    right.addInput((Input)this.getRangeTiny());
                } else {
                    TabFolder folder = new TabFolder(parent, 0);
                    folder.setLayoutData((Object)new GridData(768));
                    TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
                    ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
                    SimpleContainer left = new SimpleContainer(cols.getComposite());
                    left.addInput((Input)this.getKontoAuswahl());
                    left.addInput((Input)this.getActiveOnly());
                    SimpleContainer right = new SimpleContainer(cols.getComposite());
                    right.addInput((Input)this.getRange());
                    MultiInput range = new MultiInput(new Input[]{this.getStart(), this.getEnd()});
                    right.addInput((Input)range);
                    ButtonArea buttons = new ButtonArea();
                    buttons.addButton(String.valueOf(i18n.tr("Limits konfigurieren")) + "...", new Action(){

                        public void handleAction(Object context) throws ApplicationException {
                            try {
                                new KontoLimitsConfigure().handleAction(SaldoChart.this.getKontoAuswahl().getValue());
                                Event e = new Event();
                                e.data = SaldoChart.FORCE;
                                SaldoChart.this.reloadListener.handleEvent(e);
                            }
                            catch (RemoteException re) {
                                Logger.error((String)"unable to configurie account limits", (Throwable)re);
                                throw new ApplicationException(i18n.tr("Konfigurieren der Konto-Limits fehlgeschlagen"));
                            }
                        }
                    }, null, false, "office-chart-area.png");
                    buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

                        public void handleAction(Object context) throws ApplicationException {
                            Event event = new Event();
                            event.data = SaldoChart.FORCE;
                            SaldoChart.this.reloadListener.handleEvent(event);
                        }
                    }, null, true, "view-refresh.png");
                    buttons.paint(parent);
                }
            } else {
                SimpleContainer container = new SimpleContainer(parent);
                container.addInput((Input)this.getRangeTiny());
            }
            this.chart = new LineChart();
            this.reloadListener.handleEvent(null);
            this.chart.paint(parent);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Throwable t) {
            Logger.error((String)"unable to paint chart", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anzeigen des Saldo-Verlaufs"), 1));
        }
    }

    private Date getStartDate() throws RemoteException {
        Date date = null;
        if (this.tiny) {
            int start = (Integer)this.getRangeTiny().getValue();
            if (start >= 0) {
                long d = (long)start * 24L * 60L * 60L * 1000L;
                date = DateUtil.startOfDay((Date)new Date(System.currentTimeMillis() - d));
            }
        } else if (this.getStart().getValue() != null) {
            date = (Date)this.getStart().getValue();
        }
        if (date == null) {
            date = UmsatzUtil.getOldest(this.konto == null ? this.getKontoAuswahl().getValue() : this.konto);
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    private Date getEndDate() {
        if (this.tiny) {
            return null;
        }
        return (Date)this.getEnd().getValue();
    }

    private List<Konto> getSelectedAccounts() throws RemoteException {
        if (this.konto != null) {
            return Arrays.asList(this.konto);
        }
        ArrayList<Konto> result = new ArrayList<Konto>();
        Object o = this.getKontoAuswahl().getValue();
        if (o instanceof Konto) {
            result.add((Konto)o);
        } else if (o == null || o instanceof String) {
            boolean onlyActive = (Boolean)this.getActiveOnly().getValue();
            String group = o != null && o instanceof String ? (String)o : null;
            List<Konto> konten = KontoUtil.getKonten(onlyActive ? KontoFilter.ACTIVE : KontoFilter.ALL);
            for (Konto k : konten) {
                if (group != null && !Objects.equals(group, k.getKategorie())) continue;
                result.add(k);
            }
        }
        return result;
    }

    private class ReloadListener
    implements Listener {
        private Object oPrev = null;
        private Date startPrev = new Date();
        private Date endPrev = new Date();

        private ReloadListener() {
        }

        public void handleEvent(Event event) {
            if (SaldoChart.this.chart == null) {
                return;
            }
            try {
                boolean force;
                Object o = SaldoChart.this.konto;
                if (o == null) {
                    o = SaldoChart.this.getKontoAuswahl().getValue();
                }
                Date start = SaldoChart.this.getStartDate();
                Date end = SaldoChart.this.getEndDate();
                Date today = DateUtil.endOfDay((Date)new Date());
                boolean haveForecast = end != null && DateUtil.endOfDay((Date)end).after(today);
                boolean changed = !Objects.equals(start, this.startPrev) || !Objects.equals(end, this.endPrev) || SaldoChart.this.getActiveOnly().hasChanged() || o != this.oPrev;
                boolean bl = force = event != null && event.data == SaldoChart.FORCE;
                if (!changed && !force) {
                    return;
                }
                SaldoChart.this.chart.removeAllData();
                String startString = start != null ? HBCI.DATEFORMAT.format(start) : "";
                String endString = end != null ? HBCI.DATEFORMAT.format(end) : "";
                SaldoChart.this.chart.setTitle(i18n.tr("Saldo-Verlauf {0} - {1}", new String[]{startString, endString}));
                List<Konto> konten = SaldoChart.this.getSelectedAccounts();
                BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                AccountBalanceService balanceService = (AccountBalanceService)bs.get(AccountBalanceService.class);
                ChartDataSaldoSumme sum = new ChartDataSaldoSumme();
                sum.setColor(ColorGenerator.create((int)24));
                ChartDataSaldoSummeForecast sumForecast = haveForecast ? new ChartDataSaldoSummeForecast(sum) : null;
                int i = 1;
                for (Konto konto : konten) {
                    AccountBalanceProvider balanceProvider = balanceService.getBalanceProviderForAccount(konto);
                    AbstractChartDataSaldo balance = balanceProvider.getBalanceChartData(konto, start, today);
                    balance.setColor(ColorGenerator.create((int)(24 + i)));
                    SaldoChart.this.chart.addData(balance);
                    sum.add(balance.getData());
                    ++i;
                    if (!haveForecast) continue;
                    if (konten.size() == 1) {
                        SaldoChart.this.chart.addData(new ChartDataSaldoLimit(konto, start, SaldoLimit.Type.UPPER));
                        SaldoChart.this.chart.addData(new ChartDataSaldoLimit(konto, start, SaldoLimit.Type.LOWER));
                    }
                    ChartDataSaldoForecast forecast = new ChartDataSaldoForecast(konto, end);
                    forecast.setColor(ColorUtil.brighter(balance.getColor()));
                    SaldoChart.this.chart.addData(forecast);
                    sumForecast.add(forecast.getData());
                }
                if (konten.size() > 1) {
                    SaldoChart.this.chart.addData(sum);
                    if (sumForecast != null) {
                        SaldoChart.this.chart.addData(sumForecast);
                    }
                }
                ChartDataSaldoTrend trend = new ChartDataSaldoTrend();
                trend.setColor(ColorGenerator.create((int)17));
                trend.add(sum.getData());
                SaldoChart.this.chart.addData(trend);
                if (sumForecast != null) {
                    ChartDataSaldoTrendForecast trendForecast = new ChartDataSaldoTrendForecast(trend);
                    LinkedList<Value> all = new LinkedList<Value>();
                    all.addAll(sum.getData());
                    all.addAll(sumForecast.getData());
                    trendForecast.add(all);
                    SaldoChart.this.chart.addData(trendForecast);
                }
                if (event != null) {
                    SaldoChart.this.chart.redraw();
                }
                this.oPrev = o;
                this.startPrev = start;
                this.endPrev = end;
            }
            catch (Exception e) {
                Logger.error((String)"unable to redraw chart", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren des Saldo-Verlaufs"), 1));
            }
        }
    }
}

