/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.parts.columns.BlzColumn;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class SammelTransferBuchungList
extends TablePart {
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = null;

    public SammelTransferBuchungList(GenericIterator list, Action action) {
        super(list, action);
        this.addColumn(this.i18n.tr("Auftrag"), "this", new Formatter(){

            public String format(Object o) {
                SammelTransfer s;
                block4: {
                    if (o == null || !(o instanceof SammelTransferBuchung)) {
                        return null;
                    }
                    try {
                        SammelTransferBuchung sb = (SammelTransferBuchung)o;
                        s = sb.getSammelTransfer();
                        if (s != null) break block4;
                        return null;
                    }
                    catch (RemoteException e) {
                        Logger.error((String)"unable to read name of sammeltransfer", (Throwable)e);
                        return SammelTransferBuchungList.this.i18n.tr("Zugeh\u00f6riger Sammel-Auftrag nicht ermittelbar");
                    }
                }
                return SammelTransferBuchungList.this.i18n.tr("{0}: {1}", new String[]{HBCI.DATEFORMAT.format(s.getTermin()), s.getBezeichnung()});
            }
        });
        this.addColumn(this.i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(this.i18n.tr("Kontoinhaber"), "gegenkonto_name");
        this.addColumn(this.i18n.tr("Kontonummer"), "gegenkonto_nr");
        this.addColumn(new BlzColumn("gegenkonto_blz", this.i18n.tr("Bankleitzahl")));
        this.addColumn(this.i18n.tr("Betrag"), "this", new Formatter(){

            public String format(Object o) {
                if (o == null || !(o instanceof SammelTransferBuchung)) {
                    return null;
                }
                try {
                    SammelTransferBuchung b = (SammelTransferBuchung)o;
                    SammelTransfer s = b.getSammelTransfer();
                    String curr = HBCIProperties.CURRENCY_DEFAULT_DE;
                    if (s != null) {
                        curr = s.getKonto().getWaehrung();
                    }
                    return new CurrencyFormatter(curr, HBCI.DECIMALFORMAT).format((Object)b.getBetrag());
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to read sammeltransfer");
                    return SammelTransferBuchungList.this.i18n.tr("Betrag nicht ermittelbar");
                }
            }
        });
        this.addColumn(this.i18n.tr("Warnungen"), "warnung");
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    SammelTransferBuchung b = (SammelTransferBuchung)item.getData();
                    if (StringUtils.trimToNull((String)b.getWarnung()) != null) {
                        item.setForeground(Color.ERROR.getSWTColor());
                    } else if (b.getSammelTransfer().ausgefuehrt()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to read sammeltransfer", (Throwable)e);
                }
            }
        });
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
    }

    public SammelTransferBuchungList(final SammelTransfer a, Action action) throws RemoteException {
        super((GenericIterator)a.getBuchungen(), action);
        this.addColumn(this.i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(this.i18n.tr("Kontoinhaber"), "gegenkonto_name");
        this.addColumn(this.i18n.tr("Kontonummer"), "gegenkonto_nr");
        this.addColumn(this.i18n.tr("Bankleitzahl"), "gegenkonto_blz", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return null;
                }
                String blz = o.toString();
                String name = HBCIProperties.getNameForBank(blz);
                if (name != null && name.length() > 0) {
                    blz = String.valueOf(blz) + " [" + name + "]";
                }
                return blz;
            }
        });
        Konto k = a.getKonto();
        String curr = k != null ? k.getWaehrung() : "";
        this.addColumn(this.i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(curr, HBCI.DECIMALFORMAT));
        this.addColumn(this.i18n.tr("Warnungen"), "warnung");
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    SammelTransferBuchung b = (SammelTransferBuchung)item.getData();
                    if (StringUtils.trimToNull((String)b.getWarnung()) != null) {
                        item.setForeground(Color.ERROR.getSWTColor());
                    } else if (a.ausgefuehrt()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.setMulti(true);
        this.mc = new STMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(SammelTransferBuchungList.this.mc);
            }
        });
        super.paint(parent);
    }

    public class STMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null || !(message instanceof ImportMessage)) {
                return;
            }
            final GenericObject o = ((ImportMessage)message).getObject();
            if (o == null || !(o instanceof SammelTransferBuchung)) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SammelTransferBuchungList.this.addItem(o);
                        SammelTransferBuchungList.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

