/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class SepaDauerauftragList
extends TablePart
implements Part {
    private MessageConsumer mc = null;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public SepaDauerauftragList(Action action) throws RemoteException {
        super((GenericIterator)Settings.getDBService().createList(SepaDauerauftrag.class), action);
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    if (item == null || item.getData() == null) {
                        return;
                    }
                    SepaDauerauftrag d = (SepaDauerauftrag)item.getData();
                    if (bold) {
                        item.setFont(4, Font.BOLD.getSWTFont());
                    }
                    item.setFont(!d.isActive() ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    if (d.getLetzteZahlung() != null && new Date().after(d.getLetzteZahlung())) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while checking finish date", (Throwable)e);
                    GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Pr\u00fcfen des Ablaufdatums eines SEPA-Dauerauftrages"));
                }
            }
        });
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Gegenkonto Inhaber"), "empfaenger_name");
        this.addColumn(i18n.tr("Gegenkonto BIC"), "empfaenger_bic");
        this.addColumn(i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(i18n.tr("Turnus"), "turnus_id");
        this.addColumn(i18n.tr("N\u00e4chste Zahlung"), "naechste_zahlung", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(i18n.tr("aktiv?"), "orderid", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return "nein";
                }
                String s = o.toString();
                if (s != null && s.length() > 0) {
                    return i18n.tr("ja");
                }
                return i18n.tr("nein");
            }
        });
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.SepaDauerauftragList());
        this.mc = new TransferMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(SepaDauerauftragList.this.mc);
            }
        });
        super.paint(parent);
    }

    public class TransferMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(final Message message) throws Exception {
            if (message == null) {
                return;
            }
            final GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (!(o instanceof SepaDauerauftrag)) {
                return;
            }
            GUI.startSync((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message instanceof ObjectChangedMessage) {
                            SepaDauerauftragList.this.updateItem(o, o);
                        } else if (message instanceof ImportMessage) {
                            SepaDauerauftragList.this.addItem(o);
                            SepaDauerauftragList.this.sort();
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update item", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

