/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.formatter.IbanFormatter;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class SepaSammelTransferBuchungList
extends TablePart {
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = null;

    public SepaSammelTransferBuchungList(SepaSammelTransfer t, Action action) throws RemoteException {
        this(t.getBuchungen(), action);
    }

    public SepaSammelTransferBuchungList(List<? extends SepaSammelTransferBuchung> list, Action action) throws RemoteException {
        super(list, action);
        this.addColumn(this.i18n.tr("Auftrag"), "this", new Formatter(){

            public String format(Object o) {
                Object s;
                block4: {
                    if (o == null || !(o instanceof SepaSammelTransferBuchung)) {
                        return null;
                    }
                    try {
                        SepaSammelTransferBuchung sb = (SepaSammelTransferBuchung)o;
                        s = sb.getSammelTransfer();
                        if (s != null) break block4;
                        return null;
                    }
                    catch (RemoteException e) {
                        Logger.error((String)"unable to read name of sammeltransfer", (Throwable)e);
                        return SepaSammelTransferBuchungList.this.i18n.tr("Zugeh\u00f6riger Sammel-Auftrag nicht ermittelbar");
                    }
                }
                return SepaSammelTransferBuchungList.this.i18n.tr("{0}: {1}", new String[]{HBCI.DATEFORMAT.format(s.getTermin()), s.getBezeichnung()});
            }
        });
        this.addColumn(this.i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(this.i18n.tr("Kontoinhaber"), "empfaenger_name");
        this.addColumn(this.i18n.tr("IBAN"), "empfaenger_konto", new IbanFormatter());
        this.addColumn(this.i18n.tr("BIC"), "empfaenger_bic");
        this.addColumn(this.i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    SepaSammelTransferBuchung b = (SepaSammelTransferBuchung)item.getData();
                    if (b.getSammelTransfer().ausgefuehrt()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                    if (bold) {
                        item.setFont(5, Font.BOLD.getSWTFont());
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to read sepa sammeltransfer", (Throwable)e);
                }
            }
        });
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                SepaSammelTransferBuchungList.this.refreshSummary();
            }
        });
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(SepaSammelTransferBuchungList.this.mc);
            }
        });
        super.paint(parent);
    }

    protected String getSummary() {
        try {
            Object o = this.getSelection();
            int size = this.size();
            boolean selective = o != null && o instanceof Object[];
            List items = selective ? Arrays.asList((Object[])o) : this.getItems(false);
            double sum = 0.0;
            String curr = null;
            for (Object item : items) {
                SepaSammelTransferBuchung t = (SepaSammelTransferBuchung)item;
                if (curr == null) {
                    curr = t.getSammelTransfer().getKonto().getWaehrung();
                }
                sum += t.getBetrag();
            }
            if (curr == null) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            if (selective) {
                return this.i18n.tr("{0} Buchungen, {1} markiert, Summe: {2} {3}", new String[]{Integer.toString(size), Integer.toString(items.size()), HBCI.DECIMALFORMAT.format(sum), curr});
            }
            return this.i18n.tr("{0} Buchungen, Summe: {1} {2}", new String[]{Integer.toString(size), HBCI.DECIMALFORMAT.format(sum), curr});
        }
        catch (Exception e) {
            Logger.error((String)"error while updating summary", (Throwable)e);
            return super.getSummary();
        }
    }

    public class STMessageConsumer
    implements MessageConsumer {
        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null || !(message instanceof ImportMessage)) {
                return;
            }
            final GenericObject o = ((ImportMessage)message).getObject();
            if (o == null || !(o instanceof SepaSammelTransferBuchung)) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SepaSammelTransferBuchungList.this.addItem(o);
                        SepaSammelTransferBuchungList.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

