/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.menus.AuslandsUeberweisungList;
import de.willuhn.jameica.hbci.gui.parts.columns.AusgefuehrtColumn;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.TableItem;

public class SimpleSepaUeberweisungList
extends TablePart {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public SimpleSepaUeberweisungList(GenericIterator list) throws RemoteException {
        this(PseudoIterator.asList((GenericIterator)list));
    }

    public SimpleSepaUeberweisungList(List<AuslandsUeberweisung> list) throws RemoteException {
        super(list, (Action)new AuslandsUeberweisungNew());
        this.setContextMenu(new AuslandsUeberweisungList());
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Terminable l = (Terminable)item.getData();
                if (l == null) {
                    return;
                }
                try {
                    if (bold) {
                        item.setFont(4, Font.BOLD.getSWTFont());
                    }
                    boolean faellig = l.ueberfaellig() && !l.ausgefuehrt();
                    item.setFont(faellig ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    if (l.ausgefuehrt()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to format line", (Throwable)e);
                }
            }
        });
        this.addColumn(new KontoColumn());
        this.addColumn(i18n.tr("Gegenkonto Inhaber"), "empfaenger_name");
        this.addColumn(i18n.tr("Gegenkonto BIC"), "empfaenger_bic");
        this.addColumn(i18n.tr("Verwendungszweck"), "zweck");
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(i18n.tr("Termin"), "termin", (Formatter)new DateFormatter(HBCI.DATEFORMAT), false, 131072);
        this.addColumn(new AusgefuehrtColumn());
        this.setMulti(true);
    }
}

