/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.SpinnerInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.action.SparQuoteExport;
import de.willuhn.jameica.hbci.gui.chart.LineChart;
import de.willuhn.jameica.hbci.gui.chart.LineChartData;
import de.willuhn.jameica.hbci.gui.chart.LineStyle;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.DateFromInput;
import de.willuhn.jameica.hbci.gui.input.DateToInput;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.gui.input.RangeInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TableItem;

public class SparQuote
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(SparQuote.class);
    private static DateFormat DATEFORMAT = new SimpleDateFormat("MM.yyyy");
    private TablePart table = null;
    private LineChart chart = null;
    private KontoInput kontoauswahl = null;
    private SpinnerInput tagAuswahl = null;
    private SpinnerInput monatAuswahl = null;
    private Input from = null;
    private Input to = null;
    private RangeInput range = null;
    private List<UmsatzEntry> data = new ArrayList<UmsatzEntry>();
    private List<UmsatzEntry> trend = new ArrayList<UmsatzEntry>();
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            try {
                if (event != null && (event.type == 15 || event.type == 16)) {
                    return;
                }
                if (SparQuote.this.load()) {
                    SparQuote.this.redraw();
                    if (SparQuote.this.chart != null) {
                        SparQuote.this.chart.redraw();
                    }
                }
            }
            catch (Exception e) {
                Logger.write((Level)Level.DEBUG, (String)"unable to redraw data, it seems, the view was already closed", (Throwable)e);
            }
        }
    };

    private SelectInput getKontoAuswahl() throws RemoteException {
        if (this.kontoauswahl != null) {
            return this.kontoauswahl;
        }
        this.kontoauswahl = new KontoInput(null, KontoFilter.ALL);
        this.kontoauswahl.setPleaseChoose(i18n.tr("<Alle Konten>"));
        this.kontoauswahl.setSupportGroups(true);
        this.kontoauswahl.setComment(null);
        this.kontoauswahl.setRememberSelection("auswertungen.spartquote");
        this.kontoauswahl.addListener(this.listener);
        return this.kontoauswahl;
    }

    private SpinnerInput getTagAuswahl() throws RemoteException {
        if (this.tagAuswahl != null) {
            return this.tagAuswahl;
        }
        this.tagAuswahl = new SpinnerInput(1, 31, 1);
        this.tagAuswahl.setComment(i18n.tr(". Tag des Monats"));
        this.tagAuswahl.setName(i18n.tr("Stichtag"));
        this.tagAuswahl.setValue((Object)settings.getInt("stichtag", 1));
        this.tagAuswahl.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("stichtag", ((Integer)SparQuote.this.tagAuswahl.getValue()).intValue());
            }
        });
        this.tagAuswahl.addListener((Listener)new DelayedListener(500, this.listener));
        return this.tagAuswahl;
    }

    private SpinnerInput getMonatAuswahl() throws RemoteException {
        if (this.monatAuswahl != null) {
            return this.monatAuswahl;
        }
        this.monatAuswahl = new SpinnerInput(1, 12, 1);
        this.monatAuswahl.setComment(i18n.tr("Anzahl der Monate pro Periode"));
        this.monatAuswahl.setName(i18n.tr("Monate"));
        this.monatAuswahl.setValue((Object)settings.getInt("monate", 1));
        this.monatAuswahl.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("monate", ((Integer)SparQuote.this.monatAuswahl.getValue()).intValue());
            }
        });
        this.monatAuswahl.addListener((Listener)new DelayedListener(500, this.listener));
        return this.monatAuswahl;
    }

    private synchronized Input getFrom() {
        if (this.from != null) {
            return this.from;
        }
        this.from = new DateFromInput(null, "auswertungen.spartquote.filter.from");
        this.from.setName(i18n.tr("Von"));
        this.from.setComment(null);
        this.from.addListener(this.listener);
        return this.from;
    }

    public synchronized Input getTo() {
        if (this.to != null) {
            return this.to;
        }
        this.to = new DateToInput(null, "auswertungen.spartquote.filter.to");
        this.to.setName(i18n.tr("bis"));
        this.to.setComment(null);
        this.to.addListener(this.listener);
        return this.to;
    }

    public RangeInput getRange() {
        if (this.range != null) {
            return this.range;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range r : Range.getActiveRanges(Range.Category.AUSWERTUNG)) {
            long diff;
            if (r.getStart() == null) {
                ranges.add(r);
                continue;
            }
            java.util.Date end = r.getEnd();
            if (end == null) {
                end = DateUtil.endOfDay((java.util.Date)new java.util.Date());
            }
            if ((diff = end.getTime() - r.getStart().getTime()) <= 5184000000L) continue;
            ranges.add(r);
        }
        this.range = new RangeInput(ranges, this.getFrom(), this.getTo(), "auswertungen.spartquote.filter.range");
        this.range.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (SparQuote.this.range.getValue() != null && SparQuote.this.range.hasChanged()) {
                    SparQuote.this.listener.handleEvent(event);
                }
            }
        });
        return this.range;
    }

    public void paint(Composite parent) throws RemoteException {
        this.load();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(cols.getComposite());
        left.addInput((Input)this.getKontoAuswahl());
        left.addInput((Input)this.getTagAuswahl());
        left.addInput((Input)this.getMonatAuswahl());
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput((Input)this.getRange());
        MultiInput range = new MultiInput(new Input[]{this.getFrom(), this.getTo()});
        right.addInput((Input)range);
        ButtonArea topButtons = new ButtonArea();
        topButtons.addButton(i18n.tr("Exportieren..."), (Action)new SparQuoteExport(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    super.handleAction(SparQuote.this.table.getItems());
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to export data", (Throwable)re);
                    throw new ApplicationException(i18n.tr("Export fehlgeschlagen: {0}", re.getMessage()));
                }
            }
        }, null, false, "document-save.png");
        topButtons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SparQuote.this.listener.handleEvent(null);
            }
        }, null, true, "view-refresh.png");
        topButtons.paint(parent);
        this.table = new TablePart(this.data, null);
        this.table.addColumn(i18n.tr("Monat"), "start", (Formatter)new DateFormatter(DATEFORMAT));
        this.table.addColumn(i18n.tr("Einnahmen"), "einnahmen", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.table.addColumn(i18n.tr("Ausgaben"), "ausgaben", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.table.addColumn(i18n.tr("Sparquote"), "sparquote", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.table.setRememberOrder(true);
        this.table.setRememberColWidths(true);
        final boolean bold = Settings.getBoldValues();
        this.table.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                UmsatzEntry ue = (UmsatzEntry)item.getData();
                item.setForeground(ColorUtil.getForeground(ue.einnahmen - ue.ausgaben));
                if (bold) {
                    item.setFont(3, Font.BOLD.getSWTFont());
                }
            }
        });
        TabFolder folder2 = new TabFolder(parent, 0);
        folder2.setLayoutData((Object)new GridData(1808));
        try {
            TabGroup tab2 = new TabGroup(folder2, i18n.tr("Grafische Auswertung"), false, 1);
            this.chart = new LineChart();
            this.chart.addData(new ChartDataSparQuote());
            this.chart.addData(new ChartDataTrend());
            this.chart.setTitle(i18n.tr("Sparquote im zeitlichen Verlauf"));
            this.chart.paint(tab2.getComposite());
        }
        catch (Exception e) {
            Logger.error((String)"unable to create chart", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erzeugen des Diagramms"), 1));
        }
        TabGroup tab2 = new TabGroup(folder2, i18n.tr("Tabellarische Auswertung"));
        this.table.paint(tab2.getComposite());
    }

    private void redraw() throws RemoteException {
        if (this.data == null) {
            return;
        }
        this.table.removeAll();
        ArrayList<UmsatzEntry> tableData = new ArrayList<UmsatzEntry>(this.data);
        if (tableData.size() > 1) {
            tableData.remove(tableData.size() - 1);
        }
        for (UmsatzEntry e : tableData) {
            this.table.addItem((Object)e);
        }
    }

    private boolean load() throws RemoteException {
        this.data.clear();
        java.util.Date start = (java.util.Date)this.getFrom().getValue();
        java.util.Date end = (java.util.Date)this.getTo().getValue();
        int monate = (Integer)this.getMonatAuswahl().getValue();
        int stichtag = (Integer)this.getTagAuswahl().getValue();
        java.util.Date from = start != null ? start : UmsatzUtil.getOldest(this.getKontoAuswahl().getValue());
        from = DateUtil.startOfDay((java.util.Date)(from != null ? from : new java.util.Date()));
        java.util.Date to = DateUtil.endOfDay((java.util.Date)(end != null ? end : new java.util.Date()));
        int i = 0;
        while (i < 1000) {
            if (from.after(to)) break;
            UmsatzEntry e = new UmsatzEntry();
            e.start = from;
            e.text = DATEFORMAT.format(e.start);
            Calendar cal = Calendar.getInstance();
            cal.setTime(from);
            cal.add(2, monate);
            cal.set(5, Math.min(stichtag, cal.getActualMaximum(5)));
            from = DateUtil.startOfDay((java.util.Date)cal.getTime());
            cal.add(5, -1);
            e.end = DateUtil.endOfDay((java.util.Date)cal.getTime());
            this.data.add(e);
            ++i;
        }
        if (!this.data.isEmpty()) {
            UmsatzEntry lastEntry = new UmsatzEntry();
            long time = this.data.get(this.data.size() - 1).getEnd().getTime();
            lastEntry.end = lastEntry.start = new java.util.Date(time + 1L);
            this.data.add(lastEntry);
        }
        if (this.data.size() < 2) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie einen Zeitraum, der mindestens 2 Monate umfasst"), 2));
            return false;
        }
        DBIterator umsaetze = UmsatzUtil.getUmsaetze();
        Object o = this.getKontoAuswahl().getValue();
        if (o != null && o instanceof Konto) {
            umsaetze.addFilter("konto_id = " + ((Konto)o).getID());
        } else if (o != null && o instanceof String) {
            umsaetze.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{(String)o});
        }
        if (start != null) {
            umsaetze.addFilter("datum >= ?", new Object[]{new Date(start.getTime())});
        }
        while (umsaetze.hasNext()) {
            Umsatz u = (Umsatz)umsaetze.next();
            java.util.Date date = u.getDatum();
            if (date == null) {
                Logger.debug((String)"no date found for umsatz, skipping record");
                continue;
            }
            if (end != null && date.after(end)) break;
            UmsatzEntry e = this.getEntry(date);
            if (e == null) {
                Logger.debug((String)"no matching entry found for umsatz, skipping record");
                continue;
            }
            double betrag = u.getBetrag();
            if (betrag > 0.0) {
                e.einnahmen += betrag;
                continue;
            }
            e.ausgaben -= betrag;
        }
        this.trend.clear();
        int i2 = 0;
        while (i2 < this.data.size()) {
            this.trend.add(this.getDurchschnitt(this.data, i2));
            ++i2;
        }
        return true;
    }

    private UmsatzEntry getEntry(java.util.Date date) {
        if (date == null) {
            return null;
        }
        for (UmsatzEntry e : this.data) {
            if (e.start.after(date) || e.end.before(date)) continue;
            return e;
        }
        return null;
    }

    private UmsatzEntry getDurchschnitt(List<UmsatzEntry> list, int pos) {
        UmsatzEntry ue = new UmsatzEntry();
        int found = 0;
        int i = -4;
        while (i <= 4) {
            try {
                UmsatzEntry current = list.get(pos + i);
                ++found;
                ue.ausgaben += current.ausgaben;
                ue.einnahmen += current.einnahmen;
                if (i == 0) {
                    ue.start = current.start;
                    ue.end = current.end;
                    ue.text = current.text;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        ue.einnahmen /= (double)found;
        ue.ausgaben /= (double)found;
        return ue;
    }

    private class ChartDataSparQuote
    implements LineChartData {
        private ChartDataSparQuote() {
        }

        @Override
        public List getData() throws RemoteException {
            return SparQuote.this.data;
        }

        @Override
        public String getLabel() throws RemoteException {
            Object o = SparQuote.this.getKontoAuswahl().getValue();
            if (o != null && o instanceof String) {
                return (String)o;
            }
            if (o != null && o instanceof Konto) {
                return ((Konto)o).getBezeichnung();
            }
            return i18n.tr("Alle Konten");
        }

        @Override
        public String getDataAttribute() throws RemoteException {
            return "sparquote";
        }

        @Override
        public String getLabelAttribute() throws RemoteException {
            return "start";
        }

        @Override
        public int getLineWidth() throws RemoteException {
            return 1;
        }

        @Override
        public boolean getCurve() {
            return false;
        }

        @Override
        public LineStyle getLineStyle() throws RemoteException {
            return null;
        }

        @Override
        public boolean isLegendEnabled() throws RemoteException {
            return true;
        }

        @Override
        public int[] getColor() throws RemoteException {
            return null;
        }

        @Override
        public boolean isFilled() throws RemoteException {
            return true;
        }
    }

    private class ChartDataTrend
    extends ChartDataSparQuote {
        private ChartDataTrend() {
        }

        @Override
        public List getData() throws RemoteException {
            return SparQuote.this.trend;
        }

        @Override
        public String getLabel() throws RemoteException {
            return i18n.tr("Trend");
        }

        @Override
        public boolean getCurve() {
            return true;
        }
    }

    public static class UmsatzEntry {
        private double einnahmen = 0.0;
        private double ausgaben = 0.0;
        private java.util.Date start = null;
        private java.util.Date end = null;
        private String text = null;

        public double getEinnahmen() {
            return this.einnahmen;
        }

        public java.util.Date getStart() {
            return this.start;
        }

        public java.util.Date getEnd() {
            return this.end;
        }

        public double getAusgaben() {
            return this.ausgaben;
        }

        public String getText() {
            return this.text;
        }

        public double getSparquote() {
            return this.einnahmen - this.ausgaben;
        }
    }
}

