/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.LabelGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.SynchronizeSchedulerSettings;
import de.willuhn.jameica.hbci.gui.action.Synchronize;
import de.willuhn.jameica.hbci.gui.action.SynchronizeSchedulerOptions;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.dialogs.SynchronizeOptionsDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SynchronizeSchedulerService;
import de.willuhn.jameica.hbci.synchronize.Synchronization;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class SynchronizeList
extends TablePart {
    private static Map<String, Boolean> uncheckedCache = new HashMap<String, Boolean>();
    private static Set<String> selectedCache = new HashSet<String>();
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mcSync = new SyncMessageConsumer();
    private MessageConsumer mcCache = new CacheMessageConsumer();
    private List<Synchronization> syncList = new ArrayList<Synchronization>();
    private Button syncButton = null;
    private Listener syncButtonListener = new SyncButtonListener();

    public SynchronizeList() throws RemoteException {
        super((Action)new Configure());
        this.addColumn(i18n.tr("Offene Synchronisierungsaufgaben"), "name");
        this.removeFeature(FeatureSummary.class);
        this.setCheckable(true);
        this.setMulti(true);
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    if (item == null) {
                        return;
                    }
                    SynchronizeJob job = (SynchronizeJob)item.getData();
                    if (job == null) {
                        return;
                    }
                    item.setFont(job.isRecurring() ? Font.DEFAULT.getSWTFont() : Font.BOLD.getSWTFont());
                }
                catch (Exception e) {
                    Logger.error((String)"unable to format text", (Throwable)e);
                }
            }
        });
        ContextMenu menu = new ContextMenu();
        menu.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Aktivieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SynchronizeList.this.setChecked(true);
            }
        }, "list-add.png"));
        menu.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("Deaktivieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SynchronizeList.this.setChecked(false);
            }
        }, "list-remove.png"));
        this.setContextMenu(menu);
        this.init();
    }

    private void setChecked(boolean b) {
        Object o = this.getSelection();
        if (o == null) {
            return;
        }
        if (o instanceof Object[]) {
            this.setChecked((Object[])o, b);
        } else {
            this.setChecked(o, b);
        }
    }

    private void init() {
        try {
            this.syncList.clear();
            this.removeAll();
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            List<SynchronizeBackend> backends = ((SynchronizeEngine)service.get(SynchronizeEngine.class)).getBackends();
            for (SynchronizeBackend backend : backends) {
                Synchronization sync = new Synchronization();
                sync.setBackend(backend);
                List<SynchronizeJob> jobs = backend.getSynchronizeJobs(null);
                if (jobs == null) continue;
                for (SynchronizeJob job : jobs) {
                    boolean checked = true;
                    try {
                        checked = !uncheckedCache.containsKey(job.getName());
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to determine if job was unchecked", (Throwable)e);
                    }
                    this.addItem(job, checked);
                    sync.getJobs().add(job);
                }
                if (jobs.size() <= 0) continue;
                this.syncList.add(sync);
            }
            this.syncButtonListener.handleEvent(null);
        }
        catch (Exception e) {
            Logger.error((String)"unable to init sync list", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Anzeige der Synchronisierungsaufgaben fehlgeschlagen"), 1));
        }
    }

    public static List<Synchronization> getActiveSyncs() {
        ArrayList<Synchronization> result = new ArrayList<Synchronization>();
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        List<SynchronizeBackend> backends = ((SynchronizeEngine)service.get(SynchronizeEngine.class)).getBackends();
        for (SynchronizeBackend backend : backends) {
            List<SynchronizeJob> jobs = backend.getSynchronizeJobs(null);
            if (jobs == null || jobs.isEmpty()) continue;
            Synchronization sync = new Synchronization();
            sync.setBackend(backend);
            for (SynchronizeJob job : jobs) {
                try {
                    if (uncheckedCache.containsKey(job.getName())) continue;
                    sync.getJobs().add(job);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to add job", (Throwable)e);
                }
            }
            if (sync.getJobs().isEmpty()) continue;
            result.add(sync);
        }
        return result;
    }

    private void restoreSelect() {
        try {
            LinkedList<SynchronizeJob> selected = new LinkedList<SynchronizeJob>();
            for (Object job : this.getItems(false)) {
                SynchronizeJob j = (SynchronizeJob)job;
                if (!selectedCache.contains(j.getName())) continue;
                selected.add(j);
            }
            if (selected.size() > 0) {
                this.select(selected.toArray());
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to restore selection", (Throwable)e);
        }
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        if (this.syncButton != null) {
            return;
        }
        Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").registerMessageConsumer(this.mcSync);
        Application.getMessagingFactory().getMessagingQueue("jameica.gui.view.unbind").registerMessageConsumer(this.mcCache);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").unRegisterMessageConsumer(SynchronizeList.this.mcSync);
                Application.getMessagingFactory().getMessagingQueue("jameica.gui.view.unbind").unRegisterMessageConsumer(SynchronizeList.this.mcCache);
            }
        });
        this.syncButton = new Button(i18n.tr("S&ynchronisierung starten"), (Action)new SyncStart(), null, true, "mail-send-receive.png");
        this.addSelectionListener(this.syncButtonListener);
        super.paint(parent);
        this.init();
        this.restoreSelect();
        this.paintSynchronizeSchedulerStatus(parent);
        ButtonArea b = new ButtonArea();
        b.addButton(i18n.tr("Automatische Synchronisierung einrichten..."), c -> {
            this.cacheState();
            new SynchronizeSchedulerOptions().handleAction(c);
        }, null, false, "preferences-system-time.png");
        b.addButton(i18n.tr("Synchronisierungsoptionen..."), (Action)new Options(), null, false, "document-properties.png");
        b.addButton(this.syncButton);
        b.paint(parent);
    }

    private boolean canStart() {
        block4: {
            if (SynchronizeSchedulerSettings.isEnabled()) break block4;
            return false;
        }
        try {
            SynchronizeSchedulerService scheduler = (SynchronizeSchedulerService)Application.getServiceFactory().lookup(HBCI.class, "synchronizescheduler");
            int status = scheduler.getStatus();
            return status == 3 && !scheduler.isStarted();
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while loading synchronize scheduler status", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Status der automatischen Synchronisierung nicht ermittelbar: {0}", e.getMessage()), 1));
        }
        return false;
    }

    private void start() {
        try {
            if (!SynchronizeSchedulerSettings.isEnabled()) {
                return;
            }
            SynchronizeSchedulerService scheduler = (SynchronizeSchedulerService)Application.getServiceFactory().lookup(HBCI.class, "synchronizescheduler");
            if (!scheduler.isStarted()) {
                scheduler.start();
            }
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Automatische Synchronisierung neu gestartet"), 0));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while starting synchronize scheduler", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Start der automatischen Synchronisierung fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }

    private void paintSynchronizeSchedulerStatus(Composite parent) {
        try {
            if (!SynchronizeSchedulerSettings.isEnabled()) {
                return;
            }
            LabelGroup c = new LabelGroup(parent, i18n.tr("Automatischen Synchronisierung"));
            SynchronizeSchedulerService scheduler = (SynchronizeSchedulerService)Application.getServiceFactory().lookup(HBCI.class, "synchronizescheduler");
            int status = scheduler.getStatus();
            String text = null;
            Color color = null;
            if (status == 1) {
                text = i18n.tr("Noch nicht gestartet");
                color = Color.COMMENT;
            } else if (status == 5) {
                text = i18n.tr("Abgebrochen");
                color = Color.COMMENT;
            } else if (status == 4) {
                text = i18n.tr("Erfolgreich");
                color = Color.SUCCESS;
            } else if (status == 3) {
                text = i18n.tr("Fehler");
                color = Color.ERROR;
            } else if (status == 2) {
                text = i18n.tr("L\u00e4uft gerade...");
                color = Color.LINK;
            }
            if (text != null && color != null) {
                Date last = scheduler.getLastExecution();
                if (last != null) {
                    c.addText(i18n.tr("Letzter Status: {0} ({1})", new String[]{text, HBCI.XTRALONGDATEFORMAT.format(last)}), true, color);
                } else {
                    c.addText(i18n.tr("Letzter Status: {0}", text), true, color);
                }
            }
            if (scheduler.isStarted()) {
                c.addText(i18n.tr("N\u00e4chster Start: {0}", HBCI.XTRALONGDATEFORMAT.format(scheduler.getNextExecution())), true, Color.SUCCESS);
            } else {
                c.addText(i18n.tr("N\u00e4chster Start: die automatische Synchronisierung wurde deaktiviert (ggf. Neustart erforderlich)"), true, Color.COMMENT);
            }
            ButtonArea b = new ButtonArea();
            if (this.canStart()) {
                b.addButton(i18n.tr("Synchronisierung neu starten"), e -> {
                    this.start();
                    GUI.getCurrentView().reload();
                }, null, false, "media-playback-start.png");
            }
            b.paint(c.getComposite());
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e2) {
            Logger.error((String)"error while loading synchronize scheduler status", (Throwable)e2);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Status der automatischen Synchronisierung nicht ermittelbar: {0}", e2.getMessage()), 1));
        }
    }

    private void cacheState() {
        try {
            uncheckedCache.clear();
            List selected = this.getItems(true);
            List all = this.getItems(false);
            for (SynchronizeJob j : all) {
                if (selected.contains(j)) continue;
                uncheckedCache.put(j.getName(), Boolean.TRUE);
            }
            selectedCache.clear();
            Object o = this.getSelection();
            if (o != null) {
                if (o instanceof SynchronizeJob[]) {
                    SynchronizeJob[] synchronizeJobArray = (SynchronizeJob[])o;
                    int n = synchronizeJobArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SynchronizeJob j = synchronizeJobArray[n2];
                        selectedCache.add(j.getName());
                        ++n2;
                    }
                } else {
                    selectedCache.add(((SynchronizeJob)o).getName());
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to cache unchecked items", (Throwable)e);
        }
    }

    private class CacheMessageConsumer
    implements MessageConsumer {
        private CacheMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            SynchronizeList.this.cacheState();
        }
    }

    private static class Configure
    implements Action {
        private Configure() {
        }

        public void handleAction(Object context) throws ApplicationException {
            if (!(context instanceof SynchronizeJob)) {
                return;
            }
            ((SynchronizeJob)context).configure();
        }
    }

    private class Options
    implements Action {
        private Options() {
        }

        public void handleAction(Object context) throws ApplicationException {
            try {
                Konto k = null;
                Object o = SynchronizeList.this.getSelection();
                if (o instanceof SynchronizeJob) {
                    k = ((SynchronizeJob)o).getKonto();
                }
                if (k == null) {
                    KontoAuswahlDialog d1 = new KontoAuswahlDialog(null, KontoFilter.SYNCED, 1){

                        @Override
                        public Button getApplyButton() {
                            Button b = super.getApplyButton();
                            b.setText(i18n.tr("Synchronisationsoptionen anzeigen..."));
                            return b;
                        }
                    };
                    d1.setText(i18n.tr("Bitte w\u00e4hlen Sie das Konto, f\u00fcr welches Sie die Synchronisierungsoptionen \u00e4ndern m\u00f6chten."));
                    k = (Konto)d1.open();
                }
                if (k == null) {
                    return;
                }
                SynchronizeList.this.cacheState();
                SynchronizeOptionsDialog d = new SynchronizeOptionsDialog(k, 1);
                d.open();
                SynchronizeList.this.init();
                SynchronizeList.this.restoreSelect();
            }
            catch (OperationCanceledException k) {
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                Logger.error((String)"unable to configure synchronize options", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Konfigurieren der Synchronisierungsoptionen: {0}", e.getMessage()), 1));
            }
        }
    }

    private class SyncButtonListener
    implements Listener {
        private SyncButtonListener() {
        }

        public void handleEvent(Event event) {
            if (SynchronizeList.this.syncButton == null) {
                return;
            }
            try {
                List selected = SynchronizeList.this.getItems(true);
                SynchronizeList.this.syncButton.setEnabled(selected != null && selected.size() > 0);
            }
            catch (Exception e) {
                Logger.error((String)"unable to determine selected items", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Ermitteln der Synchronisierungsaufgaben"), 1));
            }
        }
    }

    private class SyncMessageConsumer
    implements MessageConsumer {
        private SyncMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        public void handleMessage(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        QueryMessage msg = (QueryMessage)message;
                        Integer status = (Integer)msg.getData();
                        if (status == null) {
                            return;
                        }
                        int i = status;
                        if (i == 2) {
                            ((SyncMessageConsumer)SyncMessageConsumer.this).SynchronizeList.this.syncButton.setEnabled(false);
                            return;
                        }
                        SynchronizeList.this.init();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to reload sync jobs", (Throwable)e);
                    }
                }
            });
        }
    }

    private class SyncStart
    implements Action {
        private SyncStart() {
        }

        public void handleAction(Object context) throws ApplicationException {
            try {
                SynchronizeList.this.cacheState();
                Logger.info((String)"Collecting synchronize jobs");
                List selected = SynchronizeList.this.getItems(true);
                ArrayList<Synchronization> result = new ArrayList<Synchronization>();
                for (Synchronization s : SynchronizeList.this.syncList) {
                    List<SynchronizeJob> jobs = s.getJobs();
                    ArrayList<SynchronizeJob> toExecute = new ArrayList<SynchronizeJob>();
                    for (SynchronizeJob job : jobs) {
                        if (!selected.contains(job)) continue;
                        toExecute.add(job);
                    }
                    if (toExecute.size() == 0) continue;
                    Synchronization rs = new Synchronization();
                    rs.setBackend(s.getBackend());
                    rs.setJobs(toExecute);
                    result.add(rs);
                }
                Synchronize sync = new Synchronize();
                sync.handleAction(result);
            }
            catch (OperationCanceledException selected) {
            }
            catch (RemoteException re) {
                Logger.error((String)"error while synchronizing", (Throwable)re);
                throw new ApplicationException(i18n.tr("Synchronisierung fehlgeschlagen: {0}", re.getMessage()));
            }
        }
    }
}

