/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.TableChangeListener;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureShortcut;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.input.UmsatzDaysInput;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.NeueUmsaetze;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class UmsatzList
extends TablePart
implements Extendable {
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    static Map cache = new HashMap();
    private MessageConsumer mcChanged = null;
    private MessageConsumer mcNew = null;
    private UmsatzDaysInput days = null;
    private Konto konto = null;
    private KL kl = new KL();
    private boolean filter = true;
    private boolean disposed = false;
    private List<Umsatz> umsaetze = null;
    private Integer lastDays = null;

    public UmsatzList(Konto konto, Action action) throws RemoteException {
        this((GenericIterator<Umsatz>)null, action);
        this.konto = konto;
    }

    public UmsatzList(GenericIterator<Umsatz> list, Action action) throws RemoteException {
        super(list, action);
        if (list != null) {
            this.umsaetze = PseudoIterator.asList(list);
        }
        this.addFeature((Feature)new FeatureShortcut());
        final DateFormatter df = new DateFormatter(HBCI.DATEFORMAT);
        final DateFormatter dfs = new DateFormatter(HBCI.SHORTDATEFORMAT);
        final boolean bold = Settings.getBoldValues();
        this.setMulti(true);
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                Umsatz u = (Umsatz)item.getData();
                if (u == null) {
                    return;
                }
                try {
                    item.setFont(NeueUmsaetze.isNew(u) ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    Date datum = u.getDatum();
                    Date valuta = u.getValuta();
                    if (!Objects.equals(datum, valuta)) {
                        item.setText(4, String.valueOf(df.format((Object)datum)) + " (" + dfs.format((Object)valuta) + ")");
                    }
                    if (bold) {
                        item.setFont(5, Font.BOLD.getSWTFont());
                    }
                    if (u.hasFlag(2)) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    } else {
                        ColorUtil.setForeground(item, 5, u.getBetrag());
                        ColorUtil.setForeground(item, 6, u.getUmsatzTyp());
                        item.setForeground(7, Color.FOREGROUND.getSWTColor());
                    }
                    item.setText(1, "");
                    if (u.hasFlag(1)) {
                        item.setImage(1, SWTUtil.getImage((String)"emblem-default.png"));
                    } else {
                        item.setImage(1, null);
                    }
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to format line", (Throwable)e);
                }
            }
        });
        this.addColumn("#", "id-int");
        this.addColumn(i18n.tr("Gepr\u00fcft"), "flags");
        this.addColumn(i18n.tr("Gegenkonto"), "empfaenger");
        if (settings.getBoolean("usage.display.all", false)) {
            this.addColumn(i18n.tr("Verwendungszweck"), "mergedzweck");
        } else {
            this.addColumn(i18n.tr("Verwendungszweck"), VerwendungszweckUtil.Tag.SVWZ.name());
        }
        this.addColumn(i18n.tr("Datum"), "datum_pseudo", (Formatter)df);
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.addColumn(i18n.tr("Kategorie"), "umsatztyp", null, false);
        this.addColumn(i18n.tr("Zwischensumme"), "saldo", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT), false, 131072);
        this.addColumn(i18n.tr("Notiz"), "kommentar", null, true);
        this.setRememberOrder(true);
        this.setRememberColWidths(true);
        this.setRememberState(true);
        this.mcChanged = new UmsatzChangedMessageConsumer();
        this.mcNew = new UmsatzNewMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mcChanged);
        Application.getMessagingFactory().registerMessageConsumer(this.mcNew);
        this.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                UmsatzList.this.refreshSummary();
            }
        });
        this.addChangeListener(new TableChangeListener(){

            public void itemChanged(Object object, String attribute, String newValue) throws ApplicationException {
                try {
                    Umsatz u = (Umsatz)object;
                    BeanUtil.set((Object)u, (String)attribute, (Object)newValue);
                    u.store();
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply changes", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()));
                }
            }
        });
        ExtensionRegistry.extend((Extendable)this);
    }

    public void setFilterVisible(boolean visible) {
        this.filter = visible;
    }

    protected String getSummary() {
        try {
            Object o = this.getSelection();
            int size = this.size();
            if (o == null || size == 1 || !(o instanceof Umsatz[])) {
                if (size == 1) {
                    return i18n.tr("1 Umsatz");
                }
                return i18n.tr("{0} Ums\u00e4tze", Integer.toString(size));
            }
            double sum = 0.0;
            double income = 0.0;
            double expenses = 0.0;
            Umsatz[] list = (Umsatz[])o;
            String curr = null;
            Umsatz[] umsatzArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Umsatz u = umsatzArray[n2];
                if (curr == null) {
                    curr = u.getKonto().getWaehrung();
                }
                double betrag = u.getBetrag();
                sum += betrag;
                if (betrag >= 0.01) {
                    income += betrag;
                } else {
                    expenses += betrag;
                }
                ++n2;
            }
            if (curr == null) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            return i18n.tr("{0} Ums\u00e4tze, {1} markiert, Summe: {2} {5}, Einnahmen: {3} {5}, Ausgaben: {4} {5}", new String[]{Integer.toString(size), Integer.toString(list.length), HBCI.DECIMALFORMAT.format(sum), HBCI.DECIMALFORMAT.format(income), HBCI.DECIMALFORMAT.format(Math.abs(expenses)), curr});
        }
        catch (Exception e) {
            Logger.error((String)"error while updating summary", (Throwable)e);
            return super.getSummary();
        }
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.UmsatzList(this.konto));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UmsatzList.this.disposed = true;
                Application.getMessagingFactory().unRegisterMessageConsumer(UmsatzList.this.mcChanged);
                Application.getMessagingFactory().unRegisterMessageConsumer(UmsatzList.this.mcNew);
                if (UmsatzList.this.kl != null && UmsatzList.this.kl.timeout != null) {
                    try {
                        UmsatzList.this.kl.timeout.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (this.filter) {
            SimpleContainer c = new SimpleContainer(parent);
            this.days = new UmsatzDaysInput();
            this.days.addListener((Listener)new DelayedListener(300, new Listener(){

                public void handleEvent(Event event) {
                    UmsatzList.this.kl.process();
                }
            }));
            c.addInput((Input)this.days);
        }
        if (this.filter || this.konto != null) {
            this.kl.process(true);
        }
        super.paint(parent);
        this.restoreState();
    }

    private boolean hasChanged() {
        if (!this.filter || this.days == null) {
            return false;
        }
        Integer i = (Integer)this.days.getValue();
        try {
            boolean bl = !i.equals(this.lastDays);
            return bl;
        }
        finally {
            this.lastDays = i;
        }
    }

    public String getExtendableID() {
        return UmsatzList.class.getName();
    }

    private class KL
    extends KeyAdapter {
        private boolean sleep = true;
        private Thread timeout = null;
        private Calendar cal = Calendar.getInstance();

        private KL() throws RemoteException {
        }

        public void keyReleased(KeyEvent e) {
            if (this.timeout != null) {
                this.sleep = true;
                return;
            }
            this.timeout = new Thread("UmsatzList"){

                @Override
                public void run() {
                    try {
                        try {
                            do {
                                KL.this.sleep = false;
                                1.sleep(700L);
                            } while (KL.this.sleep);
                            KL.this.process();
                        }
                        catch (InterruptedException e) {
                            KL.this.timeout = null;
                            return;
                        }
                    }
                    finally {
                        KL.this.timeout = null;
                    }
                }
            };
            this.timeout.start();
        }

        private synchronized void process() {
            this.process(false);
        }

        private synchronized void process(final boolean force) {
            if (UmsatzList.this.disposed) {
                return;
            }
            GUI.startSync((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int t;
                        if (!force && !UmsatzList.this.hasChanged()) {
                            return;
                        }
                        int n = t = ((KL)KL.this).UmsatzList.this.days != null ? (Integer)((KL)KL.this).UmsatzList.this.days.getValue() : 0;
                        if (((KL)KL.this).UmsatzList.this.konto != null) {
                            UmsatzList.this.removeAll();
                            DBIterator list = ((KL)KL.this).UmsatzList.this.konto.getUmsaetze(t);
                            while (list.hasNext()) {
                                UmsatzList.this.addItem(list.next());
                            }
                        } else if (((KL)KL.this).UmsatzList.this.umsaetze != null) {
                            UmsatzList.this.removeAll();
                            Date date = null;
                            Date limit = null;
                            if (t > 0) {
                                KL.this.cal.setTime(new Date());
                                KL.this.cal.add(6, -t);
                                KL.this.cal.set(11, 0);
                                KL.this.cal.set(12, 0);
                                KL.this.cal.set(13, 0);
                                KL.this.cal.set(14, 0);
                                limit = KL.this.cal.getTime();
                            }
                            int i = 0;
                            while (i < ((KL)KL.this).UmsatzList.this.umsaetze.size()) {
                                Umsatz u = ((KL)KL.this).UmsatzList.this.umsaetze.get(i);
                                if (u.getID() == null) {
                                    ((KL)KL.this).UmsatzList.this.umsaetze.remove(i);
                                    --i;
                                } else {
                                    date = u.getDatum();
                                    if (date == null || limit == null || !date.before(limit)) {
                                        UmsatzList.this.addItem(u);
                                    }
                                }
                                ++i;
                            }
                        }
                        UmsatzList.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while loading umsatz", (Throwable)e);
                    }
                }
            });
        }
    }

    public class UmsatzChangedMessageConsumer
    implements MessageConsumer {
        private List<Umsatz> bulk = new LinkedList<Umsatz>();
        private DelayedListener delay = new DelayedListener(70, new Listener(){

            public void handleEvent(Event event) {
                try {
                    try {
                        for (Umsatz u : UmsatzChangedMessageConsumer.this.bulk) {
                            UmsatzList.this.updateItem(u, u);
                        }
                        UmsatzList.this.refreshSummary();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                        UmsatzChangedMessageConsumer.this.bulk.clear();
                    }
                }
                finally {
                    UmsatzChangedMessageConsumer.this.bulk.clear();
                }
            }
        });

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null || !(o instanceof Umsatz)) {
                return;
            }
            this.bulk.add((Umsatz)o);
            this.delay.handleEvent(null);
        }

        public boolean autoRegister() {
            return false;
        }
    }

    public class UmsatzNewMessageConsumer
    implements MessageConsumer {
        DelayedListener updateKontoListListener = new DelayedListener(new Listener(){

            public void handleEvent(Event event) {
                if (((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.kl != null) {
                    ((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.kl.process(true);
                }
            }
        });

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            final GenericObject o = ((ObjectMessage)message).getObject();
            if (o == null || !(o instanceof Umsatz)) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Umsatz newUmsatz = (Umsatz)o;
                        if (((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.umsaetze != null) {
                            for (Object u : UmsatzList.this.getItems()) {
                                if (!BeanUtil.equals(u, (Object)newUmsatz)) continue;
                                return;
                            }
                        }
                        if (((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.konto != null && !BeanUtil.equals((Object)((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.konto, (Object)newUmsatz.getKonto())) {
                            return;
                        }
                        if (((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.umsaetze != null) {
                            ((UmsatzNewMessageConsumer)UmsatzNewMessageConsumer.this).UmsatzList.this.umsaetze.add(newUmsatz);
                        } else {
                            UmsatzList.this.addItem(newUmsatz);
                        }
                        UmsatzNewMessageConsumer.this.updateKontoListListener.handleEvent(null);
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                    }
                }
            });
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

