/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureShortcut;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.gui.menus.UmsatzList;
import de.willuhn.jameica.hbci.gui.parts.columns.KontoColumn;
import de.willuhn.jameica.hbci.messaging.NeueUmsaetze;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class UmsatzTree
extends TreePart {
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private AtomicInteger umsatzCount;
    private AtomicInteger groupCount;

    public UmsatzTree(GenericIterator list) throws RemoteException {
        super(list, (Action)new UmsatzDetail());
        this.addFeature((Feature)new FeatureShortcut());
        this.addFeature((Feature)new FeatureSummary());
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.setRememberState(true);
        this.setMulti(true);
        final boolean bold = Settings.getBoldValues();
        this.setFormatter(new TreeFormatter(){

            public void format(TreeItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                try {
                    GenericObject i = (GenericObject)item.getData();
                    Object value = i.getAttribute("betrag");
                    if (value == null || !(value instanceof Double)) {
                        return;
                    }
                    Double betrag = (Double)value;
                    if (bold) {
                        item.setFont(3, Font.BOLD.getSWTFont());
                    }
                    if (i instanceof Umsatz) {
                        Umsatz u = (Umsatz)i;
                        if (u.hasFlag(2)) {
                            item.setForeground(Color.COMMENT.getSWTColor());
                        }
                        item.setFont(NeueUmsaetze.isNew(u) ? Font.BOLD.getSWTFont() : Font.DEFAULT.getSWTFont());
                    }
                    UmsatzTyp ut = null;
                    if (i instanceof UmsatzTreeNode) {
                        ut = ((UmsatzTreeNode)i).getUmsatzTyp();
                    }
                    ColorUtil.setForeground(item, -1, ut);
                    ColorUtil.setForeground(item, 3, (double)betrag);
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting item", (Throwable)e);
                }
            }
        });
        this.addColumn(i18n.tr("Bezeichnung"), "name");
        if (settings.getBoolean("usage.display.all", false)) {
            this.addColumn(i18n.tr("Verwendungszweck"), "mergedzweck");
        } else {
            this.addColumn(i18n.tr("Verwendungszweck"), VerwendungszweckUtil.Tag.SVWZ.name());
        }
        this.addColumn(i18n.tr("Datum"), "datum_pseudo", (Formatter)new DateFormatter(HBCI.DATEFORMAT));
        this.addColumn(i18n.tr("Betrag"), "betrag", (Formatter)new CurrencyFormatter(HBCIProperties.CURRENCY_DEFAULT_DE, HBCI.DECIMALFORMAT));
        this.addColumn(i18n.tr("Notiz"), "kommentar");
        this.addColumn(new KontoColumn());
        this.setContextMenu(new UmsatzList());
        this.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                UmsatzTree.this.featureEvent(Feature.Event.REFRESH, null);
            }
        });
    }

    public void setList(GenericIterator list) {
        this.groupCount = new AtomicInteger(0);
        this.umsatzCount = new AtomicInteger(0);
        try {
            HashMap<String, UmsatzTreeNode> lookup = new HashMap<String, UmsatzTreeNode>();
            lookup.put(null, new UmsatzTreeNode(null));
            while (list.hasNext()) {
                Umsatz u = (Umsatz)list.next();
                UmsatzTreeNode node = this.getNode(lookup, u.getUmsatzTyp());
                if (node == null) continue;
                node.add(u);
                this.umsatzCount.incrementAndGet();
            }
            Iterator it = lookup.values().iterator();
            ArrayList<UmsatzTreeNode> items = new ArrayList<UmsatzTreeNode>();
            while (it.hasNext()) {
                UmsatzTreeNode u = (UmsatzTreeNode)it.next();
                if (u.getParent() != null) continue;
                items.add(u);
            }
            try {
                Collections.sort(items);
            }
            catch (Exception e) {
                Logger.warn((String)("unable to sort categories: " + e.getMessage()));
            }
            super.setList(PseudoIterator.fromArray((GenericObject[])items.toArray(new GenericObject[0])));
            this.featureEvent(Feature.Event.REFRESH, null);
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to build tree", (Throwable)re);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erzeugen der Baum-Ansicht: {0}", re.getMessage()), 1));
        }
    }

    private UmsatzTreeNode getNode(Map<String, UmsatzTreeNode> lookup, UmsatzTyp ut) throws RemoteException {
        UmsatzTreeNode node = lookup.get(ut != null ? ut.getID() : null);
        if (node != null) {
            return node;
        }
        if (ut != null && ut.hasFlag(1)) {
            return null;
        }
        node = new UmsatzTreeNode(ut);
        this.groupCount.incrementAndGet();
        lookup.put(ut.getID(), node);
        UmsatzTyp parent = (UmsatzTyp)ut.getParent();
        if (parent != null) {
            UmsatzTreeNode np = this.getNode(lookup, parent);
            if (np == null) {
                return null;
            }
            node.setParent(np);
            np.getSubGroups().add(node);
        }
        return node;
    }

    protected Feature.Context createFeatureEventContext(Feature.Event e, Object data) {
        Feature.Context ctx = super.createFeatureEventContext(e, data);
        if (this.hasEvent(FeatureSummary.class, e)) {
            ctx.addon.put("summary.text", this.getSummary());
        }
        return ctx;
    }

    private String getSummary() {
        try {
            Object o = this.getSelection();
            if (o == null || !(o instanceof Umsatz[])) {
                return i18n.tr("Kategorien: {0}, Ums\u00e4tze: {1}", new String[]{Integer.toString(this.groupCount != null ? this.groupCount.intValue() : 0), Integer.toString(this.umsatzCount != null ? this.umsatzCount.intValue() : 0)});
            }
            double sum = 0.0;
            Umsatz[] list = (Umsatz[])o;
            String curr = null;
            Umsatz[] umsatzArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Umsatz u = umsatzArray[n2];
                if (curr == null) {
                    curr = u.getKonto().getWaehrung();
                }
                sum += u.getBetrag();
                ++n2;
            }
            if (curr == null) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            return i18n.tr("{0} Ums\u00e4tze, {1} markiert, Summe: {2} {3}", new String[]{Integer.toString(this.umsatzCount != null ? Integer.valueOf(this.umsatzCount.intValue()) : null), Integer.toString(list.length), HBCI.DECIMALFORMAT.format(sum), curr});
        }
        catch (Throwable t) {
            Logger.error((String)"error while updating summary", (Throwable)t);
            return null;
        }
    }
}

