/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.BarChart;
import de.willuhn.jameica.hbci.gui.chart.ChartData;
import de.willuhn.jameica.hbci.gui.chart.ChartDataUmsatzTyp;
import de.willuhn.jameica.hbci.gui.input.UmsatzDaysInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class UmsatzTypChart
implements Part {
    private I18N i18n = null;
    private int start = UmsatzDaysInput.getDefaultDays();

    public UmsatzTypChart() {
        this.i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    }

    public void paint(Composite parent) throws RemoteException {
        try {
            SimpleContainer group = new SimpleContainer(parent, true);
            final ChartDataUmsatzTyp eData = new ChartDataUmsatzTyp(1, this.start);
            final ChartDataUmsatzTyp aData = new ChartDataUmsatzTyp(0, this.start);
            final BarChart einnahmen = new BarChart();
            final BarChart ausgaben = new BarChart();
            if (this.start < 0) {
                einnahmen.setTitle(this.i18n.tr("Einnahmen (alle Ums\u00e4tze)"));
                ausgaben.setTitle(this.i18n.tr("Ausgaben (alle Ums\u00e4tze)"));
            } else {
                einnahmen.setTitle(this.i18n.tr("Einnahmen ({0} Tage)", "" + this.start));
                ausgaben.setTitle(this.i18n.tr("Ausgaben ({0} Tage)", "" + this.start));
            }
            einnahmen.addData(eData);
            ausgaben.addData(aData);
            final UmsatzDaysInput i = new UmsatzDaysInput();
            i.addListener((Listener)new DelayedListener(300, new Listener(){
                private ChartData myEData = null;
                private ChartData myAData = null;

                public void handleEvent(Event event) {
                    try {
                        int newStart = (Integer)i.getValue();
                        if (newStart == UmsatzTypChart.this.start) {
                            return;
                        }
                        UmsatzTypChart.this.start = newStart;
                        if (this.myEData != null) {
                            einnahmen.removeData(this.myEData);
                        } else {
                            einnahmen.removeData(eData);
                        }
                        if (this.myAData != null) {
                            ausgaben.removeData(this.myAData);
                        } else {
                            ausgaben.removeData(aData);
                        }
                        this.myEData = new ChartDataUmsatzTyp(1, newStart);
                        this.myAData = new ChartDataUmsatzTyp(0, newStart);
                        if (newStart < 0) {
                            einnahmen.setTitle(UmsatzTypChart.this.i18n.tr("Einnahmen (alle Ums\u00e4tze)"));
                            ausgaben.setTitle(UmsatzTypChart.this.i18n.tr("Ausgaben (alle Ums\u00e4tze)"));
                        } else {
                            einnahmen.setTitle(UmsatzTypChart.this.i18n.tr("Einnahmen ({0} Tage)", Integer.toString(newStart)));
                            ausgaben.setTitle(UmsatzTypChart.this.i18n.tr("Ausgaben ({0} Tage)", Integer.toString(newStart)));
                        }
                        einnahmen.addData(this.myEData);
                        ausgaben.addData(this.myAData);
                        einnahmen.redraw();
                        ausgaben.redraw();
                    }
                    catch (Throwable t) {
                        Logger.error((String)"unable to redraw chart", (Throwable)t);
                        GUI.getStatusBar().setErrorText(UmsatzTypChart.this.i18n.tr("Fehler beim Aktualisieren der Umsatzverteilung"));
                    }
                }
            }));
            group.addInput((Input)i);
            Composite comp = new Composite(group.getComposite(), 0);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            comp.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(2, true);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            einnahmen.paint(comp);
            ausgaben.paint(comp);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)"unable to paint chart", (Throwable)e);
            GUI.getStatusBar().setErrorText(this.i18n.tr("Fehler beim Anzeigen der Umsatzverteilung"));
        }
    }
}

