/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class UmsatzTypList
extends TablePart
implements Part {
    private I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = null;

    public UmsatzTypList(Action action) throws RemoteException {
        super((GenericIterator)Settings.getDBService().createList(UmsatzTyp.class), action);
        this.addColumn(this.i18n.tr("Bezeichnung"), "name");
        this.addColumn(this.i18n.tr("Nummer"), "nummer-int");
        this.addColumn(this.i18n.tr("Suchbegriff"), "pattern");
        this.addColumn(this.i18n.tr("Umsatzart"), "umsatztyp", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return UmsatzTypList.this.i18n.tr("egal");
                }
                return UmsatzTypUtil.getNameForType((Integer)o);
            }
        });
        this.addColumn(this.i18n.tr("Konto"), "dummy");
        this.addColumn(this.i18n.tr("Kommentar"), "kommentar");
        this.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                if (item == null) {
                    return;
                }
                try {
                    UmsatzTyp ut = (UmsatzTyp)item.getData();
                    if (ut == null) {
                        return;
                    }
                    String kat = ut.getKontoKategorie();
                    Konto k = ut.getKonto();
                    if (k != null) {
                        item.setText(4, KontoUtil.toString(k));
                    } else if (kat != null) {
                        item.setText(4, kat);
                    }
                    ColorUtil.setForeground(item, -1, ut);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply custom color", (Throwable)e);
                }
            }
        });
        this.setMulti(true);
        this.setSummary(false);
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.setContextMenu(new de.willuhn.jameica.hbci.gui.menus.UmsatzTypList());
        this.mc = new MyMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(UmsatzTypList.this.mc);
            }
        });
        super.paint(parent);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ImportMessage.class, ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            final GenericObject data = ((ObjectMessage)message).getObject();
            if (data == null || !(data instanceof UmsatzTyp)) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        UmsatzTypList.this.removeItem(data);
                        UmsatzTypList.this.addItem(data);
                        UmsatzTypList.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add object to list", (Throwable)e);
                    }
                }
            });
        }
    }
}

