/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.ColorUtil;
import de.willuhn.jameica.hbci.gui.menus.UmsatzTypList;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class UmsatzTypTree
extends TreePart {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    private static final GenericIterator init() throws RemoteException {
        return UmsatzTypUtil.getRootElements();
    }

    public UmsatzTypTree(Action action) throws RemoteException {
        super(UmsatzTypTree.init(), action);
        this.addColumn(i18n.tr("Bezeichnung"), "name");
        this.addColumn(i18n.tr("Reihenfolge"), "nummer");
        this.addColumn(i18n.tr("Suchbegriff"), "pattern");
        this.addColumn(i18n.tr("Umsatzart"), "umsatztyp", new Formatter(){

            public String format(Object o) {
                if (o == null) {
                    return i18n.tr("egal");
                }
                return UmsatzTypUtil.getNameForType((Integer)o);
            }
        });
        this.addColumn(i18n.tr("Konto"), "dummy");
        this.addColumn(i18n.tr("Kommentar"), "kommentar");
        this.setFormatter(new TreeFormatter(){

            public void format(TreeItem item) {
                if (item == null) {
                    return;
                }
                try {
                    UmsatzTyp ut = (UmsatzTyp)item.getData();
                    if (ut == null) {
                        return;
                    }
                    String kat = ut.getKontoKategorie();
                    Konto k = ut.getKonto();
                    if (k != null) {
                        item.setText(4, KontoUtil.toString(k));
                    } else if (kat != null) {
                        item.setText(4, kat);
                    }
                    ColorUtil.setForeground(item, -1, ut);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply custom color", (Throwable)e);
                }
            }
        });
        this.setMulti(true);
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.setRememberState(true);
        this.setContextMenu(new UmsatzTypList());
    }

    public void paint(Composite parent) throws RemoteException {
        super.paint(parent);
        final MyMessageConsumer mc = new MyMessageConsumer();
        Application.getMessagingFactory().registerMessageConsumer((MessageConsumer)mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(mc);
            }
        });
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public boolean autoRegister() {
            return false;
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectDeletedMessage.class, ImportMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            ObjectMessage msg = (ObjectMessage)message;
            GenericObject o = msg.getObject();
            if (!(o instanceof UmsatzTyp)) {
                return;
            }
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        UmsatzTypTree.this.setList(UmsatzTypTree.init());
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"unable to reload list", (Throwable)re);
                    }
                }
            });
        }
    }
}

